<?php

class Common_Model_Accounts extends Zend_Db_Table_Abstract
{
    protected $_name = 'accounts';
	protected $_primary = 'id';
	 
	public function find_key($activationkey)
	{
		$result = $this->fetchRow($this->select()->from(array('a' => 'accounts'),array('id' => 'id','activationkey' => 'activationkey','accountactivated' => 'accountactivated', 'activationdate' => 'activationdate', 'object' => 'object'))->where('activationkey = ?', $activationkey));
		
		if (0 == count($result) or $result['accountactivated'] == 1) return false;
		return $result;
	}
	
	public function activate_account($id)
	{
		$data = array('accountactivated' => 1,
              'activationdate' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('accounts', $data, array('id = '.$id));
	}
	

    public function find_account($username, $password = NULL, $strict = false)
    {
		$result = $this->fetchRow($this->select()->from(array('a' => 'accounts'), array('mainId' => 'id','username','password','activationkey','accountactivated','activationdate','dateofbirth','emailaddress','object'))->where('username = ?', $username));
		if (0 == count($result)) return false;
		//die($result['object']);
		//, array('mainId' => 'id','username','password','activationkey','accountactivated','activationdate','dateofbirth','emailaddress','object')
		if (is_null($password))
		{
			if ($result['object'] == 'c') $valObject = 'patients';
			elseif ($result['object'] == 'p') $valObject = 'providers';
			elseif ($result['object'] == 'a') $valObject = 'cpadmin';
			return array($result['accountactivated'],$result['activationkey'],$result['object'], $valObject);
		}
		else
		{
			if (sha1($password) != $result['password']) return false;
			else {
				if ($result['object'] == 'c') $valObject = 'patients';
				elseif ($result['object'] == 'p') $valObject = 'providers';
				elseif ($result['object'] == 'a') $valObject = 'cpadmin';
				return array($result['accountactivated'],$result['activationkey'],$result['object'], $valObject,$result['mainId']);
			}
		}
	}
	
	public function check_password($id, $password)
	{
		$resultSet = $this->fetchAll($this->select()->where('id = ?', $id));
		if (0 == count($resultSet)) return false;
		$row = $resultSet->current(); 
		if ($this->crypPassword($password) != $row['password']) return false;
		return $row['password'];
	}
	
    public function findAccount($username, $strict = false)
    {
		$resultRow = $this->fetchRow($this->select()->where('username = ?', $username));
		if (0 == count($resultRow)) return false;
		else return $resultRow;
	}
	
    public function findAccountEmail($emailaddress, $strict = false)
    {
		$resultSet = $this->fetchAll($this->select()->where('emailaddress = ?', $emailaddress));
		if (0 == count($resultSet)) return false;
		else return true;
	}
	
    public function findAccountAndEmailAndBirthdate($emailaddress, $birthdate, $strict = false)
    {
		$resultRow = $this->fetchRow($this->select()->where('emailaddress = ?', $emailaddress)->where('dateofbirth = ?', $birthdate));
		if (0 == count($resultRow)) return false;
		else return $resultRow;
	}
	
	public function createAccount($username, $password, $activationkey, $object, $dateofbirth, $emailaddress)
	{
		$data = array('username' => $username,'password'=> $this->crypPassword($password),'activationkey' => $activationkey,'accountactivated' => 0, 'object' => $object, 'dateofbirth' => date("Ym", strtotime($dateofbirth)), 'emailaddress' => $emailaddress);
		return $this->insert($data);
	}
	
	
	public function crypPassword($password)
	{
		return sha1($password);	
	}
	
	public function updatePassword($username, $password)
	{
		$data = array('password' => $this->crypPassword($password));
		return $this->_db->update('accounts', $data, array('username = \''.$username.'\''));
	}
	
	
}
