<?php

class Auth_AccessController extends Zend_Controller_Action
{
	public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$this->request = $this->getRequest();
    }
	
	public function passwordlostAction()
	{
		$form = new Auth_Form_PatientsRegister();
		$form->passwordlost();
		$request = $this->getRequest();
		if ($request->isPost()) 
		{
			if ($form->isValid($request->getPost())) 
			{
				$account_obj = new Common_Model_Accounts();
				$userInfo = $account_obj->findAccountAndEmailAndBirthdate($this->request->getPost('sog_email_fld'), $this->request->getPost('sog_birthdate_fld'));
				if ($userInfo == false)
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Sorry, there is no such email address or birth date in our data';
				}
				else
				{	
					$session_key = sha1(sha1($userInfo['activationkey']).sha1(time()));
					$passwordresetobj = new Common_Model_Passwordresets();
					$passwordresetobj->createRequest($userInfo['username'], $session_key, date('Y-m-d H:i:s'), date('Y-m-d H:i:s', strtotime("+2 days")),0 );
					
					$linkofactivation = 'https://soconnect.secondopinionglobal.com/auth/access/resetpassword/key/'.$session_key;	
					include_once(CCPATH_APPLICATION.'/data/mails/at_password_reset.php');
					
					$mail_obj = new Common_Model_Mail();
					$mail_obj->sendmail($this->request->getPost('sog_email_fld'), '','registration@secondopinionglobal.com', 'SOG Password Reset.',$message_to_opener,'SOG Password Reset');
					
					$this->view->errors_form = false;
					$this->view->processCompleted = true;
				}
			}
			else {
				$this->view->notification = 'Error. Please make sure to provide the below fields.';
				$form->populate($request->getPost());	
			}
		}
		$this->view->loginForm = $form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('passwordlost_view.php');		
	}
	
	
	public function resetpasswordAction()
	{
		$keylink = $this->request->getParam('key');
		
		$passwordresetObj = new Common_Model_Passwordresets();
		$results = $passwordresetObj->find_key($keylink);
		
		if ($results == false)
		{
			$this->view->notification = 'Sorry, the link you are trying to reach is already expired.';
		}
		else
		{ 
			$form = new Auth_Form_PatientsRegister();
			$form->resetpassword();
			if ($this->request->isPost()) 
			{
				if ($form->isValid($this->request->getPost())) 
				{
					//echo '<pre>';print_r($results);die();
					$accountsObj = new Common_Model_Accounts();
					$userInfo = $accountsObj->findAccount($results['userAccount']);
					$accountsObj->updatePassword($results['userAccount'], $this->request->getPost('sog_password_fld'));
						
					include_once(CCPATH_APPLICATION.'/data/mails/at_password_changed.php');
					
					$mail_obj = new Common_Model_Mail();
					$mail_obj->sendmail($userInfo['emailaddress'], '','registration@secondopinionglobal.com', 'SOG Password Changed.',$message_to_opener,'SOG Password Changed');
					
					$passwordresetObj->clearLink($results['id']);
					
					$this->view->errors_form = false;
					$this->view->processCompleted = true;
				}
				else {
					$this->view->notification = 'Please make sure to fill the below fields.';
					$form->populate($this->request->getPost());	
				}
			}
			$this->view->loginForm = $form;
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('resetpassword_view.php');	
	}
	
	
	
    public function loginAction()
    {
		//echo sha1('a1');
		$form = new Auth_Form_PatientsRegister();
		$form->login();
		$request = $this->getRequest();
		if ($request->isPost()) 
		{
			//print_r($request->getPost());
			if ($form->isValid($request->getPost())) 
			{
				$this->ulogin = new Common_Model_Accounts();
				$loadMemberCheck = $this->ulogin->find_account($request->getPost('sog_login_fld'),$request->getPost('sog_password_fld'));
				if ($loadMemberCheck == false)
				{
					$this->view->notification = 'The username or password you have entered does not exist.';
					$form->populate($request->getPost());
				}
				elseif (isset($loadMemberCheck[0]) && $loadMemberCheck[0] == 0)
				{
					$this->view->notification = 'Your account is not yet activated. Please activate the account using the link provided in the email.';
					$form->populate($request->getPost());
				}
				else
				{
					$cs_session_global = new Zend_Session_Namespace('member_is_logged_in');
					$cs_session_global->svd_username = $request->getPost('sog_login_fld');
					$cs_session_global->svd_password = $request->getPost('sog_password_fld');
					$cs_session_global->svdTypeObj = $loadMemberCheck[3];
					return $this->_redirect($loadMemberCheck[3].'/portal');	
				}
			}
			else {
				$this->view->notification = 'The username or password is missing or incorrect 2.';
				$form->populate($request->getPost());	
			}
		}
		$this->view->loginForm = $form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('login_view.php');	
	}
	
    public function registerAction()
    {
		$patientRegistrationFrm = new Auth_Form_PatientsRegister();
		$this->view->errors_form = false;
		$patientRegistrationFrm->signup();
		if ($this->request->isPost()) 
		{
			
			if ($patientRegistrationFrm->isValid($this->request->getPost())) 
			{
				$secretKey = "6LcCkSQUAAAAAAWLi9oCDUpepkwRBqgcJRZvmb1H";
				$ip = $_SERVER['REMOTE_ADDR'];
				$response=file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=".$secretKey."&response=".$this->request->getPost('g-recaptcha-response')."&remoteip=".$ip);
				$responseKeys = json_decode($response,true);
				if(intval($responseKeys["success"]) !== 1) {
				  //die('dd');
				} else {
				  echo '<h2>Thanks for posting comment.</h2>';
				}
				
				
				$account_obj = new Common_Model_Accounts();
				if ($account_obj->findAccount($this->request->getPost('sog_username_fld')) != false)
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Sorry, there is already an account associated to this username.';
				}
				elseif ($account_obj->findAccountEmail($this->request->getPost('sog_emailaddress_fld')) != false)
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Sorry, this email address is already associated to another account.';
				}
				else {
					$ippp_obj = new Common_Model_Ippps();
					$idr = $ippp_obj->createIppforMember($this->request->getPost('sog_firstname_fld'),$this->request->getPost('sog_lastname_fld'),'Not Specified',$this->request->getPost('sog_cityresidence_fld'),0,$this->request->getPost('sog_countryresidence_fld'),$this->request->getPost('sog_emailaddress_fld'),$this->request->getPost('sog_phonenumber_fld'), $this->request->getPost('sog_dateofbirth_fld'));
					
					$session_key = sha1($this->request->getPost('sog_firstname_fld')).sha1($this->request->getPost('sog_lastname_fld')).sha1(time());
					$mbr_obj = new Common_Model_Patients();
					$mbr_obj->createMember($idr, $session_key);
					
					$account_obj->createAccount($this->request->getPost('sog_username_fld'), $this->request->getPost('sog_password_fld'),$session_key, 'c', $this->request->getPost('sog_dateofbirth_fld'), $this->request->getPost('sog_emailaddress_fld') );
					
					$linkofactivation = CCENV_LINK.'auth/activate/ki/key/'.$session_key;	
					include_once(CCPATH_APPLICATION.'/data/mails/at_account_creation.php');
  
					$mail_obj = new Common_Model_Mail();
					$mail_obj->sendmail($this->request->getPost('sog_emailaddress_fld'), $this->request->getPost('sog_firstname_fld'),'registration@secondopinionglobal.com', 'SOG Registration New Account.',$message_to_opener,'SOG registration of account'	);
                     
        
        
					
					return $this->_redirect('/auth/access/registered');
					
				}
			}
			else {
				$this->view->errors_form = true;
				$this->view->error_message = $patientRegistrationFrm->getMessages();
				$this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
			}
		}
		
		$this->view->signupform = $patientRegistrationFrm;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('patients/signup_view.php');	
	}	
	
    public function registeredAction()
    {
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('patients/signedup_view.php');	
	}	
	
    public function proregisterAction()
    {
		$providerRegistrationFrm = new Auth_Form_ProvidersRegister();
		$account_obj = new Common_Model_Accounts();
		$this->view->errors_form = false;
		$providerRegistrationFrm->signup();
		
		if ($this->request->isPost()) 
		{
			if ($providerRegistrationFrm->isValid($this->request->getPost())) 
			{
				$mbr_obj = new Common_Model_Providers();
				$captcha_obj = new Common_Model_Captcha();
				
				if ($captcha_obj->checkCaptcha($this->request->getPost('g-recaptcha-response')) === false) 
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Sorry, we are able to verify if you are truly human. We won\'t be able to complete your registration';
				}
				elseif ($mbr_obj->checkNPIProvider($this->request->getPost('sog_npinumber_fld')) === false) 
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Sorry, we are unable to verify your NPI number.';
				}
				elseif ($account_obj->findAccountEmail($this->request->getPost('sog_emailaddress_fld')) != false)
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Sorry, this email address is already associated to another account.';
				}
				elseif ($this->request->getPost('sog_boardcertified_fld') == 1 and ($this->request->getPost('sog_boardname_fld') == "" or $this->request->getPost('sog_boardyearsdone_fld') == "" or $this->request->getPost('sog_boardname_fld') == null or $this->request->getPost('sog_boardyearsdone_fld') == null))
				{
					if ($this->request->getPost('sog_boardname_fld') == "" or $this->request->getPost('sog_boardname_fld') == null )
					{
						$providerRegistrationFrm->sog_boardname_fld->markAsError();
						$providerRegistrationFrm->sog_boardname_fld->addError('Missing');
					}
					if ($this->request->getPost('sog_boardyearsdone_fld') == "" or $this->request->getPost('sog_boardyearsdone_fld') == null )
					{
						$providerRegistrationFrm->sog_boardyearsdone_fld->markAsError();
						$providerRegistrationFrm->sog_boardyearsdone_fld->addError('Missing');
					}
					$this->view->errors_form = true;
					$this->view->notification = 'Please provide the Board name and the years completed';
				}
				elseif (null == $this->_getParam('imat_prv_conditions', null))
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Please accept the terms and conditions before you can complete the registration.';
				}
				else {
					$session_key = sha1($this->request->getPost('sog_firstname_fld')).sha1($this->request->getPost('sog_lastname_fld')).sha1(time());
					
					$allNames = explode(' ', $this->request->getPost('sog_fullname_fld'));
					$lastName = end($allNames);

					/******************/
					$prd_obj = new Common_Model_Eppps();
					$idr = $prd_obj->createEppforProvider($lastName,'',$this->request->getPost('sog_fullname_fld'),NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,$this->request->getPost('sog_residency1_fld'),$this->request->getPost('sog_emailaddress_fld'),$this->request->getPost('sog_phonenumber1_fld'),'','',$this->request->getPost('sog_designation_fld'),$this->request->getPost('sog_otherdesignation_fld'),'',$this->request->getPost('sog_boardcertified_fld'),$this->request->getPost('sog_boardname_fld'),$this->request->getPost('sog_boardyearsdone_fld'),$this->request->getPost('sog_areaspeciality1_fld'),$this->request->getPost('sog_areaspeciality2_fld'),0,0,$this->request->getPost('sog_phonenumber2_fld'),$this->request->getPost('sog_primarystatelic_fld'),$this->request->getPost('sog_otherstateslic_fld'),$this->request->getPost('sog_medicalname_fld'),$this->request->getPost('sog_fellowship_fld'),$this->request->getPost('sog_awards_fld'),$this->request->getPost('sog_comments_fld'));
					/*********************/
					
					/*********************/
					
					//die($session_key);
					$getProviderId = $mbr_obj->createProvider($idr, $session_key, $this->request->getPost('sog_npinumber_fld'), 1);
					if (strlen($getProviderId) < 99)
					{
						$providerRef = 'P'.str_repeat('0', 4 - strlen($getProviderId)).$getProviderId;
					}
					else
					{
						$providerRef = 	'P'.$getProviderId;
					}
					//die($providerRef);
					$mbr_obj->updateProviderCode($getProviderId, $providerRef);


					
					$dateOfBirthCode = sha1(substr($this->request->getPost('sog_npinumber_fld'),0,6).$this->request->getPost('sog_emailaddress_fld'));
					$dateOfBirthCodeFinal = substr($dateOfBirthCode, 0, 6);
					$account_obj->createAccount($this->request->getPost('sog_emailaddress_fld'), '123',$session_key, 'p', $dateOfBirthCodeFinal, $this->request->getPost('sog_emailaddress_fld') );
					/*********************/
					
					/*********************/
					include_once(CCPATH_APPLICATION.'/data/mails/at_account_request_providers.php');
					$mail_obj = new Common_Model_Mail();
					$mail_obj->sendmail($this->request->getPost('sog_emailaddress_fld'), $this->request->getPost('sog_fullname_fld'),'registration@secondopinionglobal.com', 'SOG Account Management.',$message_to_opener,'SOG request new account is received');


					include_once(CCPATH_APPLICATION.'/data/mails/at_account_request_providers_ack.php');
					$mail_obj->sendmail('info@secondopinionglobal.com', 'SOG System Aut.','registration@secondopinionglobal.com', 'SOG New Provider Account.',$message_to_opener,'SOG request new account is received');
                     /*********************/
					
					return $this->_redirect('/auth/access/proregistered');
				}
			}
			else {
				$this->view->errors_form = true;
				//print_r( $providerRegistrationFrm->getMessages());
				$this->view->error_message = $providerRegistrationFrm->getMessages();
				$this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
			}
		}
		
		$this->view->signupform = $providerRegistrationFrm;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('providers/signup_view.php');	
	}	
	
    public function proregisteredAction()
    {	
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('providers/signedup_view.php');	
	}	
	
}
