<?php
	
class Core_Dictionnary 
{
	
	private $currentPath;
	private $ini = array();
	public $files = array('default'=>array('path'=>'', 'dictionnary'=>array()));
	//public $dataToSend = array();
	
	// Connexion au fichier ini de langue  l'instanciation de l'objet.
	public function __construct($dictionnaryFolder)
	{
		$this->currentPath = dirname(__FILE__).'/';
		
		if(!is_null($dictionnaryFolder))
		{
			$this->currentPath = $dictionnaryFolder;
		}
		$this->ini=&$this->files['default']['dictionnary'];
	}
	
	
	// ajout d'un dictionnaire a la liste des dictionnaires existants
	public function addDictionnary($file=NULL, $dico='default')
	{
		$diconame=strlen($dico)==0?'default':$dico;
		
		if(!is_null($file))
		{
			 if (file_exists($this->currentPath.$file)) 
			 {
				$this->files[$diconame]['path'] = $this->currentPath.$file;
				if(isset($this->files[$diconame]['dictionnary']))
				{
					$this->files[$diconame]['dictionnary'] = array_merge($this->files[$diconame]['dictionnary'], parse_ini_file($this->currentPath.$file));
				}
				else
				{
					$this->files[$diconame]['dictionnary'] =parse_ini_file($this->currentPath.$file);
				}
				if(sizeof($this->files)==1) $this->ini = &$this->files[$diconame]['dictionnary'];
			 } 
		}
	}
	
	
	//replacement d'un dictionnaire charg
	public function replaceDictionnary($file=NULL, $dico='default')
	{
		$diconame=strlen($dico)==0?'default':$dico;
		
		if(isset($this->files[$diconame])) $this->files[$diconame] =array('path'=>'', 'dictionnary'=>array());	
		if(!is_null($file))
		{
			 if (file_exists($this->currentPath.$file)) 
			 {
				$this->files[$diconame]['path'] = $this->currentPath.$file;
				$this->files[$diconame]['dictionnary'] =parse_ini_file($this->currentPath.$file);
				if(sizeof($this->files)==1) $this->ini = &$this->files[$diconame]['dictionnary'];
			 } 
		}
	}
	
	
	
	// recuperation de la traduction d'un terme dans le dictionnaire chargs et initialis par defaut
	public function __get($key)
	{
		$realKey=$key;	
		return isset($this->ini[$realKey])? $this->ini[$realKey] : "";
	}
	
	
	public function loadMy($key)
	{
		$realKey=$key;	
		return isset($this->ini[$realKey])? $this->ini[$realKey] : "";
	}
	
	// recuperation de la traduction dans un dictionnaire precis
	public function getTranslation($key, $dico="default")
	{
		$diconame=strlen($dico)==0?'default':$dico;
		
		if(array_key_exists($diconame, $this->files))
		{
			return isset($this->files[$diconame]['dictionnary'][$key])? $this->files[$diconame]['dictionnary'][$key] : "";
		}
		else
		{
			return '';
		}
	}
	
	
	
	// recuperation de la liste des fichiers de dictionnaires utiliss
	public function getDictionnaries()
	{
		return $this->files;
	}
	
	
	// verification de la presence d'un dictionnaire
	public function isDicoLoaded($file)
	{
		$isLoaded = false;
		foreach($this->files as $dico)
		{
			if($dico['path']==$file)	$isLoaded = true;
		}
		return $isLoaded;
	}
	
	
	//suppression d'un dictionnaire charg
	public function destroyDictionnary($dico='default')
	{
		$diconame=strlen($dico)==0?'default':$dico;
		if($diconame=='default')
		{
			$this->files['default']=array('path'=>'', 'dictionnary'=>array());
		}
		elseif(isset($this->files[$diconame]))
		{
			if($this->ini==$this->files[$diconame]['dictionnary']) $this->ini=&$this->files['default']['dictionnary'];
			unset($this->files[$diconame]);
		}
	}
	
	// destruction des dictionnaires en cours d'utilisation
	public function destroyDictionnaries()
	{
		$this->files=array('default'=>array('path'=>'', 'dictionnary'=>array()));
		$this->ini=&$this->files['default']['dictionnary'];
	}
	
	// Sauvegarde du fichier de langue  la destruction de l'objet. 
	public function __destruct() 
	{
		//$this->save();
	}
	
	// Mthode permettant d'ajouter une valeur dans un dictionnaire 
	public function addValue($key, $value, $dico='default') 
	{
		$diconame=strlen($dico)==0?'default':$dico;
		if(!isset($this->files[$diconame])) $this->files[$diconame] =array('path'=>'', 'dictionnary'=>array());
		$this->files[$diconame]['dictionnary'][trim($key)]= (string) $value;
	}
	
	// Mthode permettant de definir un dictionnaire par defaut 
	public function setDefault($dico='default') 
	{
		$diconame=strlen($dico)==0?'default':$dico;
		if(isset($this->files[$diconame])) $this->ini = &$this->files[$diconame]['dictionnary'];;
		//$this->files[$diconame]['dictionnary'][trim($key)]= (string) $value;
	}
	
}
	
?>