<?php

class OrganizationsController extends Zend_Controller_Action
{

    public function init()
    {
		$loadSession = new Common_Model_Access();	
		$userislogged = $loadSession->verifyAuthz();
		if (!$userislogged)
		{
			return $this->_redirect('/access/auth');
		}		
		$this->_helper->viewRenderer->setNoRender();
		$this->request = $this->getRequest();
    }

    public function indexAction()
    {
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('org_index_view.php');
    }

    public function enquireAction()
    {
		$countryObj = new General_Model_Countries();	
		$countries = $countryObj->getAllCountries(true);
		
		$this->view->countries = $countries['full'];		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('org_enquire_view.php');
    }

    public function employersAction()
    {
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('org_employers_view.php');
    }

    public function healthplanAction()
    {
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('org_healthplan_view.php');
    }

	
	
}