<?php

class Common_Model_Emails extends Zend_Db_Table_Abstract
{
    protected $_name = 'email_settings';
	protected $_primary = 'id';


	public function getEmailById($id, $parsing = false, $data)
	{
		$resultSet = $this->fetchAll($this->select()->from(array('e' => 'email_settings'),array('Id' => 'id','Email Content' => 'content','Email Subject' => 'subject','Comment' => 'comment'))->where('id = ?', $id));	
		if (!$resultSet or 0 == count($resultSet)) return false;
		$row = $resultSet->current(); 
		$results = array();
		foreach ($row as $obj => $objval) $results[$obj] = $objval;
		
		if ($parsing == true) 
		{
			$results['Email Content'] = $this->parseEmail($results['Email Content'], $data);
		}
		
		return $results;
	}
	
	public function parseEmail($email, $data)
	{
		return preg_replace_callback('/{!(.*?)!}/', function($matches) use (&$data) {return array_shift($data);}, $email);
	}
	
}
