<?php

class General_Form_Providers extends Zend_Form
{
	public $subContent = "";
    public function init()
    {
	
	}
	

	public function signup()
	{
        $this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_signup_provider');
		$this->setAttrib('enctype', 'multipart/form-data'); 
		
		$subContent = new Common_Model_Specialisations();
		$result = $subContent->getAllSpecialisations(true);
		$design_obj = new Common_Model_Designations();
		$designations = $design_obj->getAllDesignations(true);
		$states_obj = new Common_Model_States();
		$states = $states_obj->getAllStates(true);
		
		
		$this->addElement('text', 'imat_prv_username', array('label'=> 'Username:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('password', 'imat_prv_password', array('label'=> 'Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Password')));
		$this->addElement('password', 'imat_prv_repeatpassword', array('label'=> 'Confirm Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Password'),'validators' => array(array('identical', false, array('token' => 'imat_prv_password')))));
		$this->addElement('text', 'imat_prv_lastname', array('label'=> 'First Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'imat_prv_middlename', array('label'=> 'Middle Name:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'imat_prv_firstname', array('label'=> 'Last Name:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('select', 'imat_prv_professionaldesignation', array('label'=> 'Professional Designation:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array(
                    'InArray', true, array(
                        'haystack' => array_keys($designations['keys']),
                        'messages' => array(
                            Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found"
                        )
                    )
                )), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => $designations['keys']));
		$this->addElement('text', 'imat_prv_practicename', array('label'=> 'Practice Name (if any):', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'imat_prv_emailaddress', array('label'=> 'Email Address:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty', 'EmailAddress'), 'attribs'=>array('placeholder' => '')));
		$this->addElement('text', 'imat_prv_phonenumber', array('label'=> 'Phone Number:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('select', 'imat_prv_boardcertified', array('label'=> 'Board Certified:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array(
                    'InArray', true, array(
                        'haystack' => array('0','1'),
                        'messages' => array(
                            Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found"
                        )
                    )
                )), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => array('0'=>'No','1'=>'Yes')));
		$this->addElement('text', 'imat_prv_boardname', array('label'=> 'Board name:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('text', 'imat_prv_boardyearsdone', array('label'=> 'Years In Practice:', 'required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		$this->addElement('select', 'imat_prv_areaspecialisation1', array('label'=> 'Primary Speciality:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($result['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control', 'placeholder' => '1st Choice'),'multiOptions' => $result['keys']));
		$this->addElement('select', 'imat_prv_primarystatelic', array('label'=> 'Primary State License:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array(array('InArray', true, array('haystack' => array_keys($states['keys']), 'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found" )) )), 'attribs'=>array('class' => 'form-control'),'multiOptions' => $states['keys']));

		$this->addDisplayGroup(array('imat_prv_username', 'imat_prv_password','imat_prv_repeatpassword,imat_prv_lastname,imat_prv_middlename,imat_prv_firstname,imat_prv_professionaldesignation','imat_prv_practicename,imat_prv_emailaddress,imat_prv_phonenumber,imat_prv_boardcertified','imat_prv_boardname','imat_prv_boardyearsdone','imat_prv_areaspecialisation1','imat_prv_areaspecialisation2','imat_prv_areaspecialisation3'), 'topf');
		$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'), array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group'))));
		
		$this->addElement('file', 'imat_prv_credentials', array('label'=> 'Copy of your CV:', 'required' => true,'destination'=> CCPATH_APPLICATION."/data/providerscv", 'validators' => array(array('Count', false, 1),array('Size', false, 1024000),array('Extension', false, 'jpg, png, pdf, doc, docx')),'attribs'=>array() ));
		$this->addDisplayGroup(array('imat_prv_uploadpicture','imat_prv_credentials'), 'topff');
		
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$this->addElements(array($submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($submit, 'csrf'), 'topb');
		
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-12'))));  
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topff')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>'); 
	}
	
}