<?php

class Cphub_ProvidersController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Cphub_Model_Session();	
		$userislogged = $loadSession->_loadDefaultSession();
		if (!$userislogged)
		{
			return $this->_redirect('/cphub/access/login');
		}
		else {
			$this->view->userislogged = $userislogged;	
		}
    }
	
	public function indexAction()
	{
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('providers_home_view.php');
	}
	
	public function getallAction()
	{
		$provider_obj = new Cphub_Model_Providers();	
		$allproviders = $provider_obj->getProviders();
		
		$this->view->allproviders = $allproviders;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('providers_all_view.php');
	}
	
	public function getoneAction()
	{
		$request = $this->getRequest();
		$encusername = $request->getParam('p');
		
		
		
		$provider_obj = new Cphub_Model_Providers();	
		$oneprovider = $provider_obj->getOneProvider($encusername);
		
		$this->view->oneprovider = $oneprovider;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('providers_one_view.php');
	}
	
	
	
	
	
}