<?php

class AccessController extends Zend_Controller_Action
{
	protected $userislogged = '';
    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Cphub_Model_Session();	
		$this->userislogged = $loadSession->_loadDefaultSession();
		
    }	
	
	public function loginAction()
	{
		if ($this->userislogged)
		{
			return $this->_redirect('/cphub/index');
		}
		$form = new Cphub_Form_Access();
		$form->login();
		$request = $this->getRequest();
		if ($request->isPost()) 
		{
			if ($form->isValid($request->getPost())) 
			{
				$this->ulogin = new Cphub_Model_Auth();
				$loadMemberCheck = $this->ulogin->findMember($request->getPost('imatmlogin'),$request->getPost('imatmpassword'));
				if ($loadMemberCheck == false)
				{
					$this->view->notification = 'The username or password you have entered does not exist.';
					$form->populate($request->getPost());
				}
				else
				{
					$cs_session_global = new Zend_Session_Namespace('admin_is_logged_in');
					$cs_session_global->svd_username = $request->getPost('imatmlogin');
					$cs_session_global->svd_password = $request->getPost('imatmpassword');
					return $this->_redirect('cphub/index');	
				}
			}
			else {
				$this->view->notification = 'The username or password is missing or incorrect.';
				$form->populate($request->getPost());	
			}
		}
		$this->view->loginForm = $form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('access_login_view.php');
	}
	
	public function logoutAction()
	{
		if (!$this->userislogged)
		{
			return $this->_redirect('/cphub/access/login');
		}
		else
		{
			$cs_session_global = new Zend_Session_Namespace('admin_is_logged_in');	
			unset($cs_session_global->svd_username);
			unset($cs_session_global->svd_password);		
			Zend_Session::namespaceUnset('admin_is_logged_in');
			return $this->_redirect('/');
		}
	}
	
	
}