<?php

class Common_Model_Providers extends Zend_Db_Table_Abstract
{
    protected $_name = 'providers';
	protected $_primary = 'id';
	 
	public function createProvider($eppid,$username,$password, $activationkey)
	{
		$data = array('eppid' => $eppid,'username' => $username,'password'=> sha1($password),'activationkey' => $activationkey);
		return $this->insert($data);
	}
	
	public function findKeyActivation($activationkey)
	{
		$result = $this->fetchRow($this->select()->from(array('c' => 'customers'),array('id' => 'id','activationkey' => 'activationkey','accountactivated' => 'accountactivated', 'activationdate' => 'activationdate', 'ippid' => 'ippid'))->where('activationkey = ?', $activationkey));
		
		if (0 == count($result) or $result['accountactivated'] == 1) return false;
		return $result;
	}
	
	public function activateProvider($id)
	{
		$data = array('accountactivated' => 1,
              'activationdate' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
	public function checkPassword($id, $password)
	{
		$resultSet = $this->fetchAll($this->select()->where('id = ?', $id));
		if (0 == count($resultSet)) return false;
		$row = $resultSet->current(); 
		if ($this->crypPassword($password) != $row['password']) return false;
		return $row['password'];
	}
	
	public function crypPassword($password)
	{
		return sha1($password);	
	}
	
	public function updatePassword($id, $password)
	{
		$data = array('password' => $this->crypPassword($password));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
}
