<?php

class Common_Model_Payments extends Zend_Db_Table_Abstract
{
    protected $_name = 'payplans';
	protected $_primary = 'id';
	
	public function hasCustomerFilledPayAgreement($id)
	{
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()
									->from(array('c' => 'customers'))
									->where('c.id = ?', $id)
									->setIntegrityCheck(false));
									
		if (!$resultSet or 0 == count($resultSet)) 
		{
			//Halt execution because customer not found. 
			die("Halt executions");
		}
		
		$row = $resultSet->current(); 
		if ($row['payagreement_signed'] == 0) return false;
		else return true;
	}
	
	public function customerFillPayAgreement($id)
	{
		$data = array('payagreement_signed' => 1,
              'payagreement_date' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
	public function getMemberPaymentInfo($id)
	{	
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()
									->from(array('c' => 'customers'),array('payplanid' => 'payplanid'))
									->join(array('p' => 'payplans'), 'c.payplanid = p.id', array('title', 'duration'))
									->where('c.id = ?', $id)
									->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet)) return false;
		
		$row = $resultSet->current(); 
		if ($row['payplanid'] == 0) return false;
		//echo $row['title'];
		//print_r($row);
		//$results = array();
		//foreach ($row as $obj => $objval) $results[$obj] = $objval;
		return $row;
	}
	

	
	
	
	
}
