<?php

class Auth_Model_Authmembers extends Zend_Db_Table_Abstract
{
    protected $_name = 'customers';
	protected $_primary = 'id';
	 
	protected $id;
	protected $username;
	protected $password;
	protected $ippid;
	protected $billingid;
	protected $accountactivated;
	
	public function getId(){return $this->id;}
	public function getUsername(){return $this->username;}
	public function getPassword(){return $this->password;}
	public function getIppid(){return $this->ippid;}
	public function getBillingid(){return $this->billingid;}
	public function getAccountactivated() {return $this->accountactivated;}


	public function setFieldData($param, $value) {
		$this->$param = $value;
		return $this;
	}

    public function findMember($username, $password = NULL, $strict = false)
    {
		// preparing and executing the research
		$resultSet = $this->fetchAll($this->select()->where('username = ?', $username));
		if (0 == count($resultSet)) return false;
		
		$row = $resultSet->current(); 
		foreach ($row as $obj => $objval) $this->setFieldData($obj, $objval);

		//if parameter password is null and user is found return the information back to the user
		if (is_null($password)) return array($this->id,$this->ippid,$this->billingid);			
		
		// if parameter password is not null, veriyfiing now the password
		if (sha1($password) != $this->getPassword()) return false;
		return array($this->id,$this->ippid,$this->billingid,$this->accountactivated);
	}
	
	public function getRequiredUserDetail($userId)
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('email1', 'firstName','departmentId'))
			->where('id = ?', $userId));
		if (0 == count($resultSet)) return false;
		foreach ($resultSet as $k => $v)
		{
			$rs[] = array(	'email' => $v['email1'], 
							'name' => $v['firstName'],
							'departmentId' => $v['departmentId']);
		}	
		return $rs; 
	}

	public function getDeptId()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$resultSet = $this->fetchRow($this->select()->from($this, array('departmentId'))->where('username = ?', $username));
		
		if (0 == count($resultSet)) return false;
		
		$dept = $resultSet['departmentId'];
		return $dept; 
	}

	public function getUseridByUsername()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$password = $_SESSION['signingin']['svd_password'];
		$resultSet = $this->fetchRow($this->select()
							->from($this, array('id'))
							->where('username = ?', $username)
							->where('password = ?', sha1($password)));
		if (0 == count($resultSet)) return false;
		
		$id = $resultSet['id'];
		return $id;
	}
}
