<?php
	
class Core_Model
{
	
	
    /**
     * Set controller directory
     *
     * @param array|string $directory
     * @return Zend_Controller_Dispatcher_Standard
     */

	public function __construct(array $attributes = null)
	{
		if (is_array($attributes)) $this->setAttributes($attributes);

	}

	/**
	 * Set controller directory
	 *
	 * @param array|string $directory
	 * @return Zend_Controller_Dispatcher_Standard
	 */
	public function setAttributes(array $attributes)
	{
		$def_methods = get_class_methods($this);
		
		foreach ($attributes as $key => $value) 
		{
			$method = 'set' . ucfirst($key);
			
			if (in_array($method, $def_methods)) 
			{
				$this->$method($value);
			}
		}
		return $this;
	}
	
	/**
	 * Set controller directory
	 *
	 * @param array|string $directory
	 * @return Zend_Controller_Dispatcher_Standard
	 */	
	public function __set($name, $value)
	{
		$method = 'set' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid guestbook property');
		}
		$this->$method($value);
	}
	
	
	/**
	 * Set controller directory
	 *
	 * @param array|string $directory
	 * @return Zend_Controller_Dispatcher_Standard
	 */	
	public function __get($name)
	{
		$method = 'get' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid guestbook propertyes');
		}
		return $this->$method();
	}
	
}