<?php

class Providers_ScheduleController extends Zend_Controller_Action
{
	private $request;
    public function init()
    {
		$this->request = $this->getRequest();
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Common_Model_Session();	
		$userislogged = $loadSession->_loadDefaultSession();
		if (!$userislogged)
		{
			return $this->_redirect('/auth/access/login');
		}
		else {
			$this->view->userislogged = $userislogged;	
		}	
		
		
    }

    public function indexAction()
    {
		$request = $this->getRequest();
		$getm = $request->getParam('getm');
		if (($getm == '') or ($getm != '' and (($ctimestamp = strtotime('01-'.$getm)) === false)))
		{
			$ctimestamp = time();
		}
			
		$todayinfo = getdate($ctimestamp);
		$month_previous_schedule = date("m-Y", mktime(0, 0, 0, $todayinfo['mon']-1, $todayinfo['mday'], $todayinfo['year']));
		$month_current_schedule = $todayinfo['month'].' '.$todayinfo['year'];
		$month_next_schedule = date("m-Y", mktime(0, 0, 0, $todayinfo['mon']+1, $todayinfo['mday'], $todayinfo['year']));
		$todayinfo['totdays'] = date("t", mktime(0, 0, 0, $todayinfo['mon'], $todayinfo['mday'], $todayinfo['year']));
		
		
		$sched_obj = new Providers_Model_Schedule();
		//print_r( $this->view->userislogged);
		$m = ($todayinfo['mon'] < 10) ? '0'.$todayinfo['mon'] : $todayinfo['mon'];
		$allschedule = $sched_obj->getSavedScheduleByProvider($this->view->userislogged[0][0],$todayinfo['year'].'-'.$m );
		
		
		$this->view->schedules = $allschedule;
		$this->view->dayinfo = $todayinfo;
		$this->view->month_previous_schedule = $month_previous_schedule;
		$this->view->month_current_schedule = $month_current_schedule;
		$this->view->month_next_schedule = $month_next_schedule;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('sch_home_view.php');
    }
	
	
	
	
}