<?php

class Providers_ProfileController extends Zend_Controller_Action
{
    public function init()
    {
		$this->request = $this->getRequest();
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Auth_Model_Session();	
		$userislogged = $loadSession->_loadDefaultSession();
		if (!$userislogged)
		{
			return $this->_redirect('/provider/login');
		}
		else {
			$this->view->userislogged = $userislogged;	
		}
		$this->request = $this->getRequest();
		if (($this->request->getPost('IMT_action_cancel') !== null) and ($this->request->getPost('IMT_action_cancel') == 'Cancel'))
		{
			//Zend_Session::namespaceUnset('new_aptm_booking');
			return $this->_redirect('providers/portal/profile');
		}
    }
	
	public function settingsAction()
	{
		if (($this->request->getPost('IMT_action_cancelset') !== null) and ($this->request->getPost('IMT_action_cancelset') == 'Cancel'))
		{
			return $this->_redirect('providers/portal/settings');
		}
		
		$edprofil_objform = new Providers_Form_Profile();
		$settings_obj = new Common_Model_Settings();	
		$settinglist = $settings_obj->getGeneralSettingsByCustomer($this->view->userislogged[0][0]);
		$edprofil_objform->settings($settinglist);
		
		if ($this->request->isPost()) 
		{
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				foreach ($settinglist as $k=>$v)
				{
					$namefield = 'IMT_settings'.$v['id'];
					$settings_obj->updateGeneralSettingsForUser($this->view->userislogged[0][0],$v['id'], $this->request->getPost($namefield));
				}
				$user_m_sesion = new Zend_Session_Namespace('profile_editing_session');
				$user_m_sesion->update_completed = true;
				$user_m_sesion->origin = "settings";
				return $this->_redirect('providers/portal/settings/done');
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('settings_edit_view.php');
	}
	
	public function pictureAction()
	{
		$edprofil_objform = new providers_Form_Profile();
		$edprofil_objform->profilepicture();
		
		if ($this->request->isPost()) 
		{
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				$locationFile = $edprofil_objform->IMT_prof_profilepicture->getFileName(); 
				$up_fileinfo = pathinfo($locationFile);
				$location = $edprofil_objform->IMT_prof_profilepicture->getValue();	
				$filename = $this->view->userislogged[2].time().'.'.$up_fileinfo['extension'];
				$new_destination = $up_fileinfo['dirname'].'/'.$filename;
				$filterRename = new Zend_Filter_File_Rename(array('target' => $new_destination, 'overwrite' => true)); 
				$filterRename->filter($locationFile); 
				$edprofil_objform->IMT_prof_profilepicture->receive();
				
				$ipps_obj = new Common_Model_Ippps();
				$ipps_obj->updateIppByCat_picture($this->view->userislogged[0][1],$filename);
				
				$user_m_sesion = new Zend_Session_Namespace('profile_editing_session');
				$user_m_sesion->update_completed = true;
				$user_m_sesion->origin = "settings";
				return $this->_redirect('providers/portal/profile/done');
				
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('picture_edit_view.php');
	}
	
	public function passwordAction()
	{
		$edprofil_objform = new providers_Form_Profile();
		$edprofil_objform->edit_password();
		if ($this->request->isPost()) 
		{
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				$members_obj = new Common_Model_Members();
				$current_password = $members_obj->checkPassword($this->view->userislogged[0][0],$this->request->getPost('IMT_prof_oldpassword'));
				if ($current_password  == false)
				{
					$this->view->notification = "Sorry, the current Old Password is not correct.";	
				}
				elseif ($current_password == $members_obj->crypPassword($this->request->getPost('IMT_prof_newpassword')))
				{
					$this->view->notification = "Sorry, the new password cannot be the same as the old password.";
				}
				elseif ($members_obj->updatePassword($this->view->userislogged[0][0],$this->request->getPost('IMT_prof_newpassword')))
				{
					$this->view->notificationok = "The new password has been saved. Please note you would need to login again.";
					$settings_obj = new Common_Model_Settings();
					$is_send_email_auth = $settings_obj->getGeneralSettingsForUser_email($this->view->userislogged[0][0]);
					if ($is_send_email_auth == "true")
					{
						$email_obj = new Common_Model_Emails();
						$email_for_profile = $email_obj->getEmailById('user_changed_password', true, array($this->view->userislogged[1]['First name'],$this->view->userislogged[2], 'OS Name', 'Ip_address', 'location'));
						$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
						$headers  .= 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";	
						@mail($this->view->userislogged[1]['Email'], $email_for_profile['Email Subject'], $email_for_profile['Email Content'], $headers);
					}
				}
				else
				{
					$this->view->notification = "Sorry, the changes cannot be saved at this time. Please try again later.";
				}
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('profile_edit_view.php');
	}
	
	public function basicprofileAction()
	{
		$edprofil_objform = new providers_Form_Profile();
		$edprofil_objform->basicprofile();
		if ($this->request->isPost()) 
		{
			$edprofil_objform->populate($this->request->getPost());
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				$ipps_obj = new Common_Model_Ippps();
				if ($ipps_obj->updateIppByCat_basic($this->view->userislogged[0][1],$this->request->getPost('IMT_prof_firstname'),$this->request->getPost('IMT_prof_middlename'),$this->request->getPost('IMT_prof_lastname'),$this->request->getPost('IMT_prof_gender'),$this->request->getPost('IMT_prof_maritalstatus'),date("Y-m-d",strtotime($this->request->getPost('IMT_prof_dob')))))
				{
					$user_m_sesion = new Zend_Session_Namespace('profile_editing_session');
					$user_m_sesion->update_completed = true;
					$user_m_sesion->origin = "settings";
					
					$settings_obj = new Common_Model_Settings();
					$is_send_email_auth = $settings_obj->getGeneralSettingsForUser_email($this->view->userislogged[0][0]);
					if ($is_send_email_auth == "true")
					{
						$email_obj = new Common_Model_Emails();
						$email_for_profile = $email_obj->getEmailById('user_profile_changed', true, array($this->view->userislogged[1]['First name'],$this->view->userislogged[2], 'OS Name', 'Ip_address', 'location', 'Basic Profile Information'));
						$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
						$headers  .= 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";	
						@mail($this->view->userislogged[1]['Email'], $email_for_profile['Email Subject'], $email_for_profile['Email Content'], $headers);
					}
					
					return $this->_redirect('providers/portal/profile/done');
				}
				else
				{
					$this->view->notification = "Sorry, the changes cannot be saved at this time. Please try again later.";
				}
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		else
		{
			$ddata_preset['IMT_prof_firstname'] = $this->view->userislogged[1]['First name'];
			$ddata_preset['IMT_prof_middlename'] = $this->view->userislogged[1]['Middle name'];
			$ddata_preset['IMT_prof_lastname'] = $this->view->userislogged[1]['Last name'];
			$ddata_preset['IMT_prof_gender'] = $this->view->userislogged[1]['Sex'];
			$ddata_preset['IMT_prof_maritalstatus'] = $this->view->userislogged[1]['Marital status'];
			$ddata_preset['IMT_prof_dob'] = $this->view->userislogged[1]['Birth date'];
			$edprofil_objform->populate($ddata_preset);
		}
		
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('profile_edit_view.php');
	}
	
	public function contactAction()
	{
		$edprofil_objform = new providers_Form_Profile();
		$edprofil_objform->contact_details();
		if ($this->request->isPost()) 
		{
			$edprofil_objform->populate($this->request->getPost());
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				$ipps_obj = new Common_Model_Ippps();
				if ($ipps_obj->updateIppByCat_contact($this->view->userislogged[0][1],$this->request->getPost('IMT_prof_email'),$this->request->getPost('IMT_prof_address'),$this->request->getPost('IMT_prof_apartnum'),$this->request->getPost('IMT_prof_streetnum'),$this->request->getPost('IMT_prof_zip'),$this->request->getPost('IMT_prof_country'),$this->request->getPost('IMT_prof_city'),$this->request->getPost('IMT_prof_state'),$this->request->getPost('IMT_prof_cellphone'),$this->request->getPost('IMT_prof_homephone'),$this->request->getPost('IMT_prof_workphone')))
				{
					$user_m_sesion = new Zend_Session_Namespace('profile_editing_session');
					$user_m_sesion->update_completed = true;
					$user_m_sesion->origin = "settings";
					
					$settings_obj = new Common_Model_Settings();
					$is_send_email_auth = $settings_obj->getGeneralSettingsForUser_email($this->view->userislogged[0][0]);
					if ($is_send_email_auth == "true")
					{
						$email_obj = new Common_Model_Emails();
						$email_for_profile = $email_obj->getEmailById('user_profile_changed', true, array($this->view->userislogged[1]['First name'],$this->view->userislogged[2], 'OS Name', 'Ip_address', 'location', 'Contact details information'));
						$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
						$headers  .= 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";	
						@mail($this->view->userislogged[1]['Email'], $email_for_profile['Email Subject'], $email_for_profile['Email Content'], $headers);
					}
					
					return $this->_redirect('providers/portal/profile/done');
				}
				else
				{
					$this->view->notification = "Sorry, the changes cannot be saved at this time. Please try again later.";
				}
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		else
		{
			$ddata_preset['IMT_prof_email'] = $this->view->userislogged[1]['Email'];
			$ddata_preset['IMT_prof_address'] = $this->view->userislogged[1]['Address'];
			$ddata_preset['IMT_prof_apartnum'] = $this->view->userislogged[1]['House or Apt no'];
			$ddata_preset['IMT_prof_streetnum'] = $this->view->userislogged[1]['Street name'];
			$ddata_preset['IMT_prof_zip'] = $this->view->userislogged[1]['Zip'];
			$ddata_preset['IMT_prof_country'] = $this->view->userislogged[1]['Country'];
			$ddata_preset['IMT_prof_city'] = $this->view->userislogged[1]['City'];
			$ddata_preset['IMT_prof_state'] = $this->view->userislogged[1]['State'];
			$ddata_preset['IMT_prof_cellphone'] = $this->view->userislogged[1]['Cellphone'];
			$ddata_preset['IMT_prof_homephone'] = $this->view->userislogged[1]['Homephone'];
			$ddata_preset['IMT_prof_workphone'] = $this->view->userislogged[1]['Workphone'];
			$edprofil_objform->populate($ddata_preset);
		}
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('profile_edit_view.php');
	}
	
	public function occupationAction()
	{
		$edprofil_objform = new providers_Form_Profile();
		$edprofil_objform->occupation();
		if ($this->request->isPost()) 
		{
			$edprofil_objform->populate($this->request->getPost());
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				$ipps_obj = new Common_Model_Ippps();
				if ($ipps_obj->updateIppByCat_occupation($this->view->userislogged[0][1],$this->request->getPost('IMT_prof_profession')))
				{
					$user_m_sesion = new Zend_Session_Namespace('profile_editing_session');
					$user_m_sesion->update_completed = true;
					$user_m_sesion->origin = "settings";
					
					$settings_obj = new Common_Model_Settings();
					$is_send_email_auth = $settings_obj->getGeneralSettingsForUser_email($this->view->userislogged[0][0]);
					if ($is_send_email_auth == "true")
					{
						$email_obj = new Common_Model_Emails();
						$email_for_profile = $email_obj->getEmailById('user_profile_changed', true, array($this->view->userislogged[1]['First name'],$this->view->userislogged[2], 'OS Name', 'Ip_address', 'location', 'Occupation'));
						$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
						$headers  .= 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";	
						@mail($this->view->userislogged[1]['Email'], $email_for_profile['Email Subject'], $email_for_profile['Email Content'], $headers);
					}
					
					return $this->_redirect('providers/portal/profile/done');
				}
				else
				{
					$this->view->notification = "Sorry, the changes cannot be saved at this time. Please try again later.";
				}
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		else
		{
			$ddata_preset['IMT_prof_profession'] = $this->view->userislogged[1]['Occupation'];
			$edprofil_objform->populate($ddata_preset);
		}
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('profile_edit_view.php');
	}
	
	public function medicalAction()
	{
		$edprofil_objform = new providers_Form_Profile();
		$edprofil_objform->medical();
		if ($this->request->isPost()) 
		{
			$edprofil_objform->populate($this->request->getPost());
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				$ipps_obj = new Common_Model_Ippps();
				if ($ipps_obj->updateIppByCat_medical($this->view->userislogged[0][1],$this->request->getPost('IMT_prof_medical')))
				{
					$user_m_sesion = new Zend_Session_Namespace('profile_editing_session');
					$user_m_sesion->update_completed = true;
					$user_m_sesion->origin = "settings";
					
					$settings_obj = new Common_Model_Settings();
					$is_send_email_auth = $settings_obj->getGeneralSettingsForUser_email($this->view->userislogged[0][0]);
					if ($is_send_email_auth == "true")
					{
						$email_obj = new Common_Model_Emails();
						$email_for_profile = $email_obj->getEmailById('user_profile_changed', true, array($this->view->userislogged[1]['First name'],$this->view->userislogged[2], 'OS Name', 'Ip_address', 'location', 'Medical Insurance'));
						$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
						$headers  .= 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";	
						@mail($this->view->userislogged[1]['Email'], $email_for_profile['Email Subject'], $email_for_profile['Email Content'], $headers);
					}
					
					return $this->_redirect('providers/portal/profile/done');
				}
				else
				{
					$this->view->notification = "Sorry, the changes cannot be saved at this time. Please try again later.";
				}
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		else
		{
			$ddata_preset['IMT_prof_medical'] = $this->view->userislogged[1]['Medicinsur_planname'];
			$edprofil_objform->populate($ddata_preset);
		}
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('profile_edit_view.php');
	}
	
}