<?php

class ScheduleController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Common_Model_Session();	
		$this->view->userislogged = $loadSession->_loadDefaultSession();	
		
		$this->request = $this->getRequest();
		$this->aptmSession = new Zend_Session_Namespace('aptm_new_booking');
    }

    public function indexAction()
    {
		//
	}

	public function chooseAction()
    {	
		$this->aptmSession->aptminfo_link = 'schedule/choose';	
		$fields_expters_obj = new Common_Model_Specialisations();
		$all_experts = $fields_expters_obj->getAllSpecialisations_all(true, false);
		
		if ($this->request->isPost()) {
			$providerType = $this->request->getPost('providerType', 'none');
			if ($providerType == 'none'){
				$this->view->errnoprovsel = true;
			}
			else{
				$this->aptmSession->aptminfo['field'] = $providerType;
				if ($all_experts['full'][$providerType]['choiceduration'] == 1){
					$this->aptmSession->aptminfo_link = 'schedule/duration';
					return $this->_redirect('patients/schedule/duration');
				}
				else{
					$this->aptmSession->aptminfo['orgnlink'] = 'schedule/choose';
					$this->aptmSession->aptminfo_link = 'schedule/schway';
					return $this->_redirect('patients/schedule/schway');
				}
			}
		}
		
		if (isset($this->aptmSession->aptminfo['field'])){
			$this->view->selected = $this->aptmSession->aptminfo['field'];	
		}	
		$this->view->all_experts = $all_experts['full'];
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/choose_view.php');	
	}
	
	public function durationAction()
    {	
		if ($this->request->isPost()) {
			$durationConsultation = $this->request->getPost('durationConsultation', 'none');
			$this->aptmSession->aptminfo['duration'] = $durationConsultation;
			$this->aptmSession->aptminfo['orgnlink'] = 'schedule/duration';
			$this->aptmSession->aptminfo_link = 'schedule/schway';
			return $this->_redirect('patients/schedule/schway');
		}	
	
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/duration_view.php');	
	}

	public function schwayAction()
    {	
		$this->view->linkBack = $this->aptmSession->aptminfo['orgnlink'];
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/schway_view.php');	
	}

	
	public function slctimeAction(){	
		$this->aptmSession->aptminfo_link = 'schedule/slctime';
			
		$schAppointment_form = new Patients_Form_Appointments();
		$timenow = time();
		$nearesttime = round($timenow / (30 * 60)) * (30 * 60);
		$time2now = date('a', $nearesttime);
		$alltimes  = $this->settimer($nearesttime);
		
		// Request the form object for validation
		$schAppointment_form->requests();
		if ($this->request->isPost()) {
			$audioonly = $this->request->getPost('phoneconsultation', 'off');
			if ($audioonly == 'on') $audioonly = 1;
			if ($audioonly == 'off') $audioonly = 0;
			
			$appointmentDate = $this->request->getPost('appointmentDate', 'none');
			$appointmentTime = $this->request->getPost('appointmentTime', 'none');
			$appointmentTime2 = $this->request->getPost('appointmentTime2', 'none');
			
			$this->aptmSession->aptminfo['appointmentDate'] = $appointmentDate;
			$this->aptmSession->aptminfo['appointmentTime'] = $appointmentTime;
			$this->aptmSession->aptminfo['appointmentTime2'] = $appointmentTime;
			$this->aptmSession->aptminfo['audioonly'] = $audioonly;
			
			$this->aptmSession->aptminfo_link = 'schedule/providers';
			return $this->_redirect('patients/schedule/providers');
		
		}
		if (isset($this->aptmSession->aptminfo['field'])){
			$this->view->oldAptmData = $this->aptmSession->aptminfo;	
		}	
		$this->view->all_times = $alltimes;
		$this->view->time2 = $time2now;
		$this->view->form_startapm = $schAppointment_form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/slctime_view.php');
	}
	
	public function providersAction(){	
		//$this->aptmSession->aptminfo_link = 'schedule/slctime';
		//$fields_provdr_obj = new Common_Model_Provdroptions();
		//$all_providers = $fields_provdr_obj->getProvidersByCriteria($aptm_sesion->aptm_details['IMT_apm_fieldconsult'], $aptm_sesion->aptm_details['IMT_apm_dateapm'], intval($aptm_sesion->aptm_details['IMT_apm_duration']), $this->view->userislogged[1]['State']);
		
		// Request the form object for validation
		//$form_startapm->providers_select();
		//$form_startapm_2->providers_change();	
		
		//$details_aptm = $aptm_sesion->aptm_details;
		
		
		
	//	$details_aptm['IMT_apm_fieldconsult'] = $all_experts['keys'][$details_aptm['IMT_apm_fieldconsult']];
	//	$details_aptm['IMT_apm_commethod'] = $all_communications['keys'][$details_aptm['IMT_apm_commethod']];
		
		//$this->view->list_providers = $all_providers;
		if ($this->request->isPost()) {
			$this->aptmSession->aptminfo_link = 'schedule/insurance';
			return $this->_redirect('patients/schedule/insurance');
		}
	
	
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/providers_view.php');
	}
	
	
	public function nwslctimeAction(){
		$aptm_sesion = new Zend_Session_Namespace('new_aptm_booking');

		
		if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'requests')
			{
				return $this->_redirect('patients/appointments/new/s/'.$aptm_sesion->session_started);
			}
			
			// get all specialistations
			$fields_expters_obj = new Common_Model_Specialisations();
			$all_experts = $fields_expters_obj->getAllSpecialisations(true, false);
			
			// get all cmmunications method
			$fields_comms_obj = new Common_Model_Communications();
			$all_communications = $fields_comms_obj->getAllCommunications(true);
			
			// get timings
			$timenow = time();
			$nearesttime = round($timenow / (30 * 60)) * (30 * 60);
			$time2now = date('a', $nearesttime);
			$alltimes  = $this->settimer($nearesttime);
			
			// Request the form object for validation
			$form_startapm->requests($all_experts['keys'], $all_communications['keys']);
			if ($request->isPost()) 
			{
				if ($form_startapm->isValid($request->getPost())) 
				{
					$aptm_sesion->aptm_details = array(
						'IMT_apm_fieldconsult'=>$request->getPost('IMT_apm_fieldconsult'),
						'IMT_apm_commethod'=>$request->getPost('IMT_apm_commethod'),
						'IMT_apm_dateapm'=>$request->getPost('IMT_apm_dateapm'),
						'IMT_apm_description'=>$request->getPost('IMT_apm_description'),
						'IMT_apm_duration'=>$request->getPost('IMT_apm_duration'),
						'IMT_apm_timeapm'=>$request->getPost('IMT_apm_timeapm'),
						'IMT_apm_timeapm2'=>$request->getPost('IMT_apm_timeapm2')
					);
					$aptm_sesion->session_started = 'providers';
					return $this->_redirect('patients/appointments/new/s/providers');	
				}
				else {
					$form_startapm->populate($request->getPost());
				}
			}
			else {
				if (isset($aptm_sesion->aptm_details['IMT_apm_fieldconsult']))
				{
					$ddata_preset['IMT_apm_fieldconsult'] = $aptm_sesion->aptm_details['IMT_apm_fieldconsult'];
					$ddata_preset['IMT_apm_commethod'] = $aptm_sesion->aptm_details['IMT_apm_commethod'];
					$ddata_preset['IMT_apm_dateapm'] = $aptm_sesion->aptm_details['IMT_apm_dateapm'];
					$ddata_preset['IMT_apm_description'] = $aptm_sesion->aptm_details['IMT_apm_description'];
					$ddata_preset['IMT_apm_duration'] = $aptm_sesion->aptm_details['IMT_apm_duration'];
					$ddata_preset['IMT_apm_timeapm'] = $aptm_sesion->aptm_details['IMT_apm_timeapm'];
					$ddata_preset['IMT_apm_timeapm2'] = $aptm_sesion->aptm_details['IMT_apm_timeapm2'];
					$form_startapm->populate($ddata_preset);
				}
			}
			$this->view->all_experts = $all_experts['full'];
			$this->view->all_communications = $all_communications['full'];
			$this->view->all_times = $alltimes;
			if (isset($aptm_sesion->aptm_details['IMT_apm_timeapm2']))
			{
				$this->view->time2 = $aptm_sesion->aptm_details['IMT_apm_timeapm2'];
			}
			else {
				$this->view->time2 = $time2now;
			}
			$this->view->form_startapm = $form_startapm;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_requests_view.php');
		
	}
	
	public function insuranceAction()
    {	
		if ($this->request->isPost()) {
			
			//	$this->aptmSession->aptminfo['field'] = $providerType;
				$this->aptmSession->aptminfo_link = 'schedule/payment';
				return $this->_redirect('patients/schedule/payment');
			
		}
			
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/insurance_view.php');	
	}
	
	
	public function paymentAction()
    {	
		if ($this->request->isPost()) {
			
			//	$this->aptmSession->aptminfo['field'] = $providerType;
				$this->aptmSession->aptminfo_link = 'schedule/medical';
				return $this->_redirect('patients/schedule/medical');
			
		}
			
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/payment_view.php');	
	}
	
	
	public function medicalAction()
    {	
		if ($this->request->isPost()) {
			
			//	$this->aptmSession->aptminfo['field'] = $providerType;
				$this->aptmSession->aptminfo_link = 'schedule/pharmacy';
				return $this->_redirect('patients/schedule/pharmacy');
			
		}
		$ros_obj = new Common_Model_Ros();	
			$questionslist = $ros_obj->getrosCodes();
			$this->view->qros = $questionslist;
			

			
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/medical_view.php');	
	}
	
	public function pharmacyAction()
    {	
		if ($this->request->isPost()) {
			
			//	$this->aptmSession->aptminfo['field'] = $providerType;
				$this->aptmSession->aptminfo_link = 'schedule/confirm';
				return $this->_redirect('patients/schedule/confirm');
			
		}
		

			
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/pharmacy_view.php');	
	}	
	
	public function confirmAction()
    {	
		if ($this->request->isPost()) {
			
			//	$this->aptmSession->aptminfo['field'] = $providerType;
				$this->aptmSession->aptminfo_link = 'schedule/pharmacy';
				return $this->_redirect('patients/appointments');
			
		}
		

			
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/confirm_view.php');	
	}	

	
	public function slcproviderAction()
	{
		if ($this->request->isPost()) {
			//die($this->request->getPost('schSelectAprovider'));
			$this->aptmSession->aptminfo_link = 'schedule/insurance';
			return $this->_redirect('patients/schedule/providragenda');
		}
	
	
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/slcproviders_view.php');

	}
	
	public function providragendaAction()
	{
		$getm = $this->request->getParam('getm');
		if (($getm == '') or ($getm != '' and (($ctimestamp = strtotime('01-'.$getm)) === false)))
		{
			$ctimestamp = time();
		}
			
		$todayinfo = getdate($ctimestamp);
		$month_previous_schedule = date("m-Y", mktime(0, 0, 0, $todayinfo['mon']-1, $todayinfo['mday'], $todayinfo['year']));
		$month_current_schedule = $todayinfo['month'].' '.$todayinfo['year'];
		$month_next_schedule = date("m-Y", mktime(0, 0, 0, $todayinfo['mon']+1, $todayinfo['mday'], $todayinfo['year']));
		$todayinfo['totdays'] = date("t", mktime(0, 0, 0, $todayinfo['mon'], $todayinfo['mday'], $todayinfo['year']));
		
		
		$sched_obj = new Providers_Model_Schedule();
		//print_r( $this->view->userislogged);
		$m = ($todayinfo['mon'] < 10) ? '0'.$todayinfo['mon'] : $todayinfo['mon'];
		$allschedule = $sched_obj->getSavedScheduleByProvider($this->view->userislogged[0][0],$todayinfo['year'].'-'.$m );
		
		
		$this->view->schedules = $allschedule;
		$this->view->dayinfo = $todayinfo;
		$this->view->month_previous_schedule = $month_previous_schedule;
		$this->view->month_current_schedule = $month_current_schedule;
		$this->view->month_next_schedule = $month_next_schedule;
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm/schedule/providragenda_view.php');
	
	}
	
	public function newAction()
    {	
		//** Init of the variables default **//
		$aptm_sesion = new Zend_Session_Namespace('new_aptm_booking');
		$form_startapm = new Patients_Form_Appointments();
		$form_startapm_2 = new Patients_Form_Appointments();
		$request = $this->getRequest();
		$step = $request->getParam('s');
		
		//** If cancel option is received, abort all the operations and exit **//
		if (($request->getPost('IMT_action_cancel') !== null) and ($request->getPost('IMT_action_cancel') == 'Cancel'))
		{
			Zend_Session::namespaceUnset('new_aptm_booking');
			return $this->_redirect('patients/portal');
		}
		
		//** Screen the step  **//
		if ($step == "" or $step == "preface")
		{
			
		}
		elseif ($step == "requests") {
			
		}
		elseif ($step == "providers") {
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'providers')
			{
				return $this->_redirect('patients/appointments/new/s/'.$aptm_sesion->session_started);
			}
			
			// Generate the list of available providers
			$fields_provdr_obj = new Common_Model_Provdroptions();
			$all_providers = $fields_provdr_obj->getProvidersByCriteria($aptm_sesion->aptm_details['IMT_apm_fieldconsult'], $aptm_sesion->aptm_details['IMT_apm_dateapm'], intval($aptm_sesion->aptm_details['IMT_apm_duration']), $this->view->userislogged[1]['State']);
			
			// Request the form object for validation
			$form_startapm->providers_select();
			$form_startapm_2->providers_change();
			
			// Proceed to posted data
			if ($request->isPost()) 
			{
				if (($request->getPost('Change') !== null) and ($request->getPost('Change') == 'Change')) 
				{
					if ($form_startapm_2->isValid($request->getPost()))
					{
						$aptm_sesion->session_started = 'requests';
						return $this->_redirect('patients/appointments/new/s/requests');
					}
					else {
						echo '<pre>';print_r($form_startapm_2->getMessages());
						die('should not happen');	
					}
				}
				elseif (($request->getPost('Submit') !== null) and ($request->getPost('Submit') == 'Submit')) 
				{
					if ($form_startapm->isValid($request->getPost()))
					{
						$aptm_sesion->aptm_details['IMT_apm_provider'] = $request->getPost('IMT_apm_provider');
						$aptm_sesion->session_started = 'confirm';
						return $this->_redirect('patients/appointments/new/s/confirm');
					}
					else {
						echo '<pre>';print_r($form_startapm->getMessages());
						die('should not happen');	
					}
				}
			}
			
			$details_aptm = $aptm_sesion->aptm_details;
			// get all specialistations
			$fields_expters_obj = new Common_Model_Specialisations();
			$all_experts = $fields_expters_obj->getAllSpecialisations(true, false);
			
			// get all cmmunications method
			$fields_comms_obj = new Common_Model_Communications();
			$all_communications = $fields_comms_obj->getAllCommunications(true);
			
			$details_aptm['IMT_apm_fieldconsult'] = $all_experts['keys'][$details_aptm['IMT_apm_fieldconsult']];
			$details_aptm['IMT_apm_commethod'] = $all_communications['keys'][$details_aptm['IMT_apm_commethod']];
			
			$this->view->list_providers = $all_providers;
			$this->view->form_apmdetails = $details_aptm;
			$this->view->form_changepro = $form_startapm_2;
			$this->view->form_selectpro = $form_startapm;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_providers_view.php');
		}
		elseif ($step == "medical") {
			$ros_obj = new Common_Model_Ros();	
			$questionslist = $ros_obj->getrosCodes();
			$this->view->qros = $questionslist;
			
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm/medical_view.php');
			
		}
		elseif ($step == "confirm") {
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'confirm')
			{
				return $this->_redirect('patients/appointments/new/s/'.$aptm_sesion->session_started);
			}
			
			$form_startapm->confirm();
			$form_startapm_2->providers_change();
			
			if ($request->isPost()) 
			{
				if (($request->getPost('Change') !== null) and ($request->getPost('Change') == 'Change')) 
				{
					if ($form_startapm_2->isValid($request->getPost()))
					{
						$aptm_sesion->session_started = 'requests';
						return $this->_redirect('patients/appointments/new/s/requests');
					}
					else {
						echo '<pre>';print_r($form_startapm_2->getMessages());
						die('should not happen');	
					}
				}
				elseif (($request->getPost('Submit') !== null) and ($request->getPost('Submit') == 'Submit')) 
				{
					if ($form_startapm->isValid($request->getPost()))
					{
						$fields_provdr_obj = new Common_Model_Appointments();
						$fields_provdr_obj->addAnAppointment($aptm_sesion->aptm_details['IMT_apm_dateapm'], intval($aptm_sesion->aptm_details['IMT_apm_duration']), $this->view->userislogged[0][0],$aptm_sesion->aptm_details['IMT_apm_provider']);
						//die('ss');
						$aptm_sesion->session_started = 'postface';
						return $this->_redirect('patients/appointments/new/s/postface');
					}
					else {
						echo '<pre>';print_r($form_startapm->getMessages());
						die('should not happen');	
					}
				}
			}
			
			$details_aptm = $aptm_sesion->aptm_details;
			// get all specialistations
			$fields_expters_obj = new Common_Model_Specialisations();
			$all_experts = $fields_expters_obj->getAllSpecialisations(true);
			
			// get all cmmunications method
			$fields_comms_obj = new Common_Model_Communications();
			$all_communications = $fields_comms_obj->getAllCommunications(true);
			
			$details_aptm['IMT_apm_fieldconsult'] = $all_experts['keys'][$details_aptm['IMT_apm_fieldconsult']];
			$details_aptm['IMT_apm_commethod'] = $all_communications['keys'][$details_aptm['IMT_apm_commethod']];
			
			//$this->view->list_providers = $all_providers;
			$this->view->form_apmdetails = $details_aptm;
			$this->view->form_confirm = $form_startapm;
			$this->view->form_changepro = $form_startapm_2;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_confirm_view.php');
		}
		elseif ($step == "postface") {
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'postface')
			{
				return $this->_redirect('patients/appointments/new/s/'.$aptm_sesion->session_started);
			}
			Zend_Session::namespaceUnset('new_aptm_booking');
			
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_postface_view.php');
		}
		else {
			// default action
			die("no step provided !!?");
		}
	}
	
	private function settimer($begin)
	{
		$counter = $begin;
		for ($i = 1; $i<=24; $i++)
		{
			$times[] = date('h:i', $counter).'<br>';
			$counter = strtotime("+30 minutes", $counter);
		}
		return $times;
		
	}
}