<?php

class PaymentsController extends Zend_Controller_Action
{
	private $request;
    public function init()
    {
		$this->request = $this->getRequest();
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Common_Model_Session();	
		$this->view->userislogged = $loadSession->_loadDefaultSession();	
			
    }
//
    public function indexAction()
    {
		$this->_forward('ratesgreement');
    }
	
	public function ratesgreementAction() {
		$fields_expters_obj = new Common_Model_Specialisations();
		$all_experts = $fields_expters_obj->getAllSpecialisations(true);
		$this->view->all_experts = $all_experts['full'];
		$form_agreement = new Patients_Form_Payments();
		$form_agreement->pay_agreement();
		$payObj = new Common_Model_Payments();			
		if ($payObj->hasCustomerFilledPayAgreement($this->view->userislogged[0][0]) != false)
		{
			$this->view->locked = true;	
		}
		else 
		{
			$this->view->error_notsigned = false;
			if ($this->request->isPost()) 
			{
				if ($form_agreement->isValid($this->request->getPost())) 
				{
					if (null == $this->_getParam('subscription', null))
					{
						$this->view->error_notsigned = true;
					}
					else {
						$payObj->customerFillPayAgreement($this->view->userislogged[0][0]);
						$this->view->signed = true;
					}
				}
				else {
					die("Well, should not be here -- Agreement Pay Page");
				}
			}
			
			$this->view->form_agreement = $form_agreement;
		}
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('pay_home_view.php');	
	}
	
	public function binfoAction() {
		$billing_obj = new Common_Model_Billing();
		$updatetodo = $this->request->getParam('update');
		
		if ($updatetodo or ($this->view->userislogged[0][2] == "" or $this->view->userislogged[0][2] == 0))
		{
			$form_billing = new Patients_Form_Payments();
			$form_billing->billing_info();
			if ($this->view->userislogged[0][2] != "" and $this->view->userislogged[0][2] != 0)
			{
				$billing_info = $billing_obj->getBillingInfo($this->view->userislogged[0][2], true);
			}
			else {
				$billing_info = false;	
			}
			
			if ($this->request->isPost()) 
			{
				if (null == $this->_getParam('IMT_pay_sametick', null))
				{
					$sametick = 0;
				}
				else {
					$sametick = 1;
				}
				
				
				if ($form_billing->isValid($this->request->getPost())) 
				{
					if ($this->view->userislogged[0][2] != 0)
					{
						$billing_obj->updateBillingInfo($this->view->userislogged[0][2], $this->request->getPost('IMT_pay_firstname'),$this->request->getPost('IMT_pay_lastname'),$this->request->getPost('IMT_pay_address'),$this->request->getPost('IMT_pay_city'),$this->request->getPost('IMT_pay_zipcode'),$this->request->getPost('IMT_pay_country'),$this->request->getPost('IMT_pay_email'),$this->request->getPost('IMT_pay_phone'),$sametick);
					}
					else {
						$billing_obj->createBillingInfo($this->view->userislogged[0][0], $this->request->getPost('IMT_pay_firstname'),$this->request->getPost('IMT_pay_lastname'),$this->request->getPost('IMT_pay_address'),$this->request->getPost('IMT_pay_city'),$this->request->getPost('IMT_pay_zipcode'),$this->request->getPost('IMT_pay_country'),$this->request->getPost('IMT_pay_email'),$this->request->getPost('IMT_pay_phone'),$sametick);
					}
					$user_m_sesion = new Zend_Session_Namespace('billing_editing_session');
					$user_m_sesion->update_completed = true;
					$user_m_sesion->origin = "settings";
					return $this->_redirect('/customers/payments/binfo');
				}
				else {
					//echo '<pre>';print_r($form_billing->getMessages()); 
					die("Well, should not be here -- Agreement Pay Page");
				}
			}
			else {
				if ($billing_info != false)
				{
					$form_billing->populate($billing_info);
				}
			}
			$this->view->form_billing = $form_billing;
			$countryObj = new Common_Model_Countries();	
			$options = $countryObj->getAllCountries(true);
			$this->view->countries = $options['full'];
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('pay_cc_view.php');
		}
		else
		{
			$billing_info = $billing_obj->getBillingInfo($this->view->userislogged[0][2], false);
			
			$prof_sesion = new Zend_Session_Namespace('billing_editing_session');
			if (isset($prof_sesion->update_completed))
			{
				$this->view->updated = true;
				//should be one time operation. So we delete the session space to avoid confusion
				Zend_Session::namespaceUnset('billing_editing_session');
			}
			$this->view->billinginfo = $billing_info;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('pay_billing_view.php');
		}
	}
	
	/*public function planAction()
	{
		$request = $this->getRequest();
		$step = $request->getParam('selection');
		
		//load existing payment options
		$userInfo = new Common_Model_Payments();	
		$payinfo = $userInfo->hasCustomerFilledPayAgreement($this->view->userislogged[0][0]);
		
		if ($step == "" or $step == "options")
		{
			$payObj = new Common_Model_Payments();	
			$options = $payObj->getPayOptions(true);
			
			$this->view->options = $options['full'];
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('pay_plan_view.php');
		}
		elseif ($step == "ccdetails") {
			
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('pay_cc_view.php');
		}
		elseif ($step == "billing") {
			$countryObj = new Common_Model_Countries();	
			$options = $countryObj->getAllCountries(true);
			
			$this->view->countries = $options['full'];
			
			
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('pay_billing_view.php');
		}		
		elseif ($step == "confirm") {
			
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('pay_confirm_view.php');
		}
		elseif ($step == "postface") {
			
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('pay_postface_view.php');
		}
		else {
			die("Page::PayPlanOptions::View::No Step provided.");	
		}
	}*/
	
	public function bhistoryAction()
	{
		$payObj = new Common_Model_Billing();	
		$records = $payObj->getBillingRecords($this->view->userislogged[0][0]);
		
		$this->view->records = $records;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('pay_billhistory_view.php');
	}
	
}