<?php

class MdnowController extends Zend_Controller_Action
{
    public function init()
    {
		$this->request = $this->getRequest();
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Common_Model_Session();	
		$userislogged = $loadSession->_loadDefaultSession();
		if (!$userislogged)
		{
			return $this->_redirect('/members/login');
		}
		else {
			$this->view->userislogged = $userislogged;	
		}
		
		$this->aptmSession = new Zend_Session_Namespace('aptm_online_mdnow');
    }
	
	public function indexAction()
	{
		
	}
	
	public function startAction()
	{
		//unset($this->aptmSession);
		if (isset($this->aptmSession->mdnow['mdnowid_'.$this->view->userislogged[0][3]])){
			//a session has already started
			return $this->_redirect('patients/mdnow/medical');
		}
		if ($this->request->isPost()) {
			//create the session for the meeting
			$this->aptmSession->mdnow['mdnowid_'.$this->view->userislogged[0][3]] = substr(sha1(time().$this->view->userislogged[1]['Email']), 0, 15);
			$this->aptmSession->mdnow['mdnow']['topic'] = 'Meeting with Patient '.$this->view->userislogged[1]['Last name'];
			
			
			return $this->_redirect('patients/mdnow/medical');
		}


		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('mdnow/start_view.php');
	}
	
	public function medicalAction()
	{
		if ($this->request->isPost()) {
			return $this->_redirect('patients/mdnow/pharmacy');
		}
		
		$ros_obj = new Common_Model_Ros();	
		$questionslist = $ros_obj->getrosCodes();
		$this->view->qros = $questionslist;

		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('mdnow/medical_view.php');
	}
	
	public function pharmacyAction()
    {	
		if ($this->request->isPost()) {
			return $this->_redirect('patients/mdnow/payment');
		}
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('mdnow/pharmacy_view.php');
	}	
		
	public function paymentAction()
    {	
		if ($this->request->isPost()) {
			return $this->_redirect('patients/mdnow/confirm');
		}
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('mdnow/payment_view.php');
	}	
		
	public function confirmAction()
    {	
		$this->view->meetingAlreadyCreated = false;
		
		if (!isset($this->aptmSession->mdnow['mdnowid_'.$this->view->userislogged[0][3]])){
			return $this->_redirect('patients/mdnow/start');
		}
		
		if (isset($this->aptmSession->mdnow['mdnow']['zoomIsCreated']) && $this->aptmSession->mdnow['mdnow']['zoomIsCreated'] == true) {
			$this->view->meetingAlreadyCreated = true;
		}
		else {
			$params = array(
				'userId' => "auYrMWclQjyDx7FUtViJWA",
				'meetingTopic' => $this->aptmSession->mdnow['mdnow']['topic'],
				'meetingType' => '1',
				'durationMeeting' => '15'
			);
			$zoomApiObject = new Vendors_Zoom_Zoom();
			$responseZoom = $zoomApiObject->createAMeeting($params);
			$responseZoomDecoded = json_decode($responseZoom, true);
			
			if ($responseZoom == false or isset($responseZoomDecoded['error'])) {
				$this->view->meetingCannotBeCreated = true;
			}
			else{
				$this->view->meetingCannotBeCreated = false;
				
				//echo '<pre>'; print_r($responseZoomDecoded);
				$this->aptmSession->mdnow['mdnow']['uuid'] = $responseZoomDecoded['uuid'];
				$this->aptmSession->mdnow['mdnow']['zoomid'] = $responseZoomDecoded['id'];
				$this->aptmSession->mdnow['mdnow']['status'] = $responseZoomDecoded['status'];
				$this->view->meetingId = $responseZoomDecoded['id'];
				
				$sessionuxObject = new Common_Model_Sessionux();
				$sessionuxObject->createNewSession($responseZoomDecoded['id'], $this->aptmSession->mdnow['mdnow']['topic'], 1, 15, $this->view->userislogged[0][3], date('Y-m-d H:i:s'));
				
			}
		}
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('mdnow/confirm_view.php');
	}	
    
	
}