<?php

class CnsiqController extends Zend_Controller_Action
{
	private $request;
    public function init()
    {
		$this->request = $this->getRequest();
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Common_Model_Session();	
		$this->view->userislogged = $loadSession->_loadDefaultSession();
    }
	
	public function cnsiqnotcompleteAction()
	{
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('cnsiq_notcomplete_view.php');
	}

    public function indexAction()
    {
		
		$cnsiq_obj = new Common_Model_Cnsiq();			
		if ($cnsiq_obj->hasCnsiqFilledByCustomer($this->view->userislogged[0][0]) == false)
		{
			return $this->_forward('cnsiqnotcomplete');
		}
		else
		{
			$questionslist = $cnsiq_obj->getCnsiqByCustomer($this->view->userislogged[0][0]);
			$this->view->questionlists = $questionslist;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
			echo $this->view->render('cnsiq_home_view.php');
		}
    }
	
	public function takeAction()
	{
		$cnsiq_obj = new Common_Model_Cnsiq();	
		$questionslist = $cnsiq_obj->getCnsiqCodes();
		
		$cnsiq_objform = new Patients_Form_Cnsiq();
		$cnsiq_objform->taketest($questionslist);
		if ($this->request->isPost()) 
		{
			if ($cnsiq_objform->isValid($this->request->getPost())) 
			{
				foreach ($questionslist as $k=>$s)
				{
					foreach ($s as $k2 => $v)
					{
						$namefield = 'IMT_cnsiqx_'.$v['idqx'];
						$cnsiq_obj->saveCnsiqAnswersForCustomer($v['idqx'],$this->view->userislogged[0][0], $this->request->getPost($namefield));
					}
				}
				die();
				$cnsiq_obj->customerFillCnsiq($this->view->userislogged[0][0]);
				$this->view->notificationok = "Thank you for filling up the CNSiQ. ";	
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
			
		}
		
		$this->view->cnsiq_form = $cnsiq_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('cnsiq_take_view.php');
	}
	
	public function updateAction()
	{
		$cnsiq_obj = new Common_Model_Cnsiq();	
		$questionslist = $cnsiq_obj->getCnsiqCodes();
		
		$cnsiq_objform = new Patients_Form_Cnsiq();
		$cnsiq_objform->taketest($questionslist);
		if ($this->request->isPost()) 
		{
			if ($cnsiq_objform->isValid($this->request->getPost())) 
			{
				foreach ($questionslist as $k=>$s)
				{
					foreach ($s as $k2 => $v)
					{
						$namefield = 'IMT_cnsiqx_'.$v['idqx'];
						$cnsiq_obj->updateCnsiqAnswersForCustomer($v['idqx'],$this->view->userislogged[0][0], $this->request->getPost($namefield));
					}
				}
				$cnsiq_obj->customerFillCnsiq($this->view->userislogged[0][0]);
				$this->view->notificationok = "Thank you for filling up the CNSiQ. ";	
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
			
		}
		
		$this->view->cnsiq_form = $cnsiq_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('cnsiq_update_view.php');
	}
	
	
	
}