<?php

class AppointmentsController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Common_Model_Session();	
		$this->view->userislogged = $loadSession->_loadDefaultSession();	
	
    }

    public function indexAction()
    {
		$aptm_oj = new Common_Model_Appointments();	
		$this->view->upaptms = $aptm_oj->getUpAppointmentsbyCustomer($this->view->userislogged[0][0]);
		$this->view->preaptms = $aptm_oj->getPreAppointmentsbyCustomer($this->view->userislogged[0][0]);
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('apm_home_view.php');	
    }
	
    public function settingsAction()
    {
		$request = $this->getRequest();
		$prof_sesion = new Zend_Session_Namespace('appointment_editing_session');
		if ((null ==  $request->getParam('done')) and isset($prof_sesion->update_completed))
		{
			$done = $request->getParam('done');
			$this->view->orign = $prof_sesion->origin; 
			//should be one time operation. So we delete the session space to avoid confusion
			Zend_Session::namespaceUnset('appointment_editing_session');
		}
		
		$settings_obj = new Common_Model_Settings();	
		$settinglist = $settings_obj->getAppointmentsSettingsByCustomer($this->view->userislogged[0][0]);
		
		$this->view->settings = $settinglist;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm_settings_view.php');	
    }
	
	public function esettingsAction()
	{
		$this->request = $this->getRequest();
		if (($this->request->getPost('IMT_action_cancelset') !== null) and ($this->request->getPost('IMT_action_cancelset') == 'Cancel'))
		{
			return $this->_redirect('patients/appointments/settings');
		}
		
		$edprofil_objform = new Patients_Form_Appointments();
		$settings_obj = new Common_Model_Settings();	
		$settinglist = $settings_obj->getAppointmentsSettingsByCustomer($this->view->userislogged[0][0]);
		$edprofil_objform->settings($settinglist);
		
		if ($this->request->isPost()) 
		{
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				foreach ($settinglist as $k=>$v)
				{
					$namefield = 'IMT_settings'.$v['id'];
					$settings_obj->updateGeneralSettingsForUser($this->view->userislogged[0][0],$v['id'], $this->request->getPost($namefield));
				}
				$user_m_sesion = new Zend_Session_Namespace('appointment_editing_session');
				$user_m_sesion->update_completed = true;
				$user_m_sesion->origin = "settings";
				return $this->_redirect('patients/appointments/settings/done');
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('apm_esettings_view.php');
	}
	
	
	public function nwemcyAction()
    {	
		$form_startapm = new Patients_Form_Appointments();	
		$request = $this->getRequest();
		$aptm_sesion = new Zend_Session_Namespace('aptm_new_booking');
		
		// Is startOver situation ?
		$startOver = $request->getParam('startover', 'out');
		if ($startOver == 'in') {
			unset($aptm_sesion->session_started);
			unset($aptm_sesion->aptminfo_link);
			unset($aptm_sesion->aptminfo);
			return $this->_redirect('patients/appointments/nwemcy');
		}
		
		// Session already started. Asked user choice.
		if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'nwemcy')
		{
			$this->view->linkContinueCreateAptm = $aptm_sesion->aptminfo_link ;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm/new/leftover_view.php');
		}
		else{
			$aptm_sesion->session_started = 'nwemcy'; 
			$aptm_sesion->aptminfo_link = 'appointments/nwprescreen';
			$form_startapm->preface();
			if ($request->isPost()) 
			{
				if ($form_startapm->isValid($request->getPost())) 
				{
					$aptm_sesion->session_started = 'choose';
					return $this->_redirect('patients/schedule/choose');
				}
			}
			
			$this->view->form_startapm = $form_startapm;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm/new/emcy_view.php');		
		}
	}

	public function nwprescreenAction()
    {	
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm/new/prescreen_view.php');	
	}

}