<?php

class Common_Model_Ippps extends Zend_Db_Table_Abstract
{
    protected $_name = 'ipps';
	protected $_primary = 'ippid';
	 
	protected $ippid;
	protected $lastname;
	protected $middlename;
	protected $firstname;
	protected $birthdate;
	protected $sex;
	protected $maritalstatus;
	protected $house_aptno;
	protected $streetname;
	protected $city;
	protected $state;
	protected $zip;
	protected $email;
	protected $cellphone;
	protected $homephone;
	protected $workphone;
	protected $occupation;
	protected $medicinsur_planname;
	protected $employerid;
	
	public function getIppid(){return $this->ippid;}
	public function getLastname(){return $this->lastname;}
	public function getMiddlename(){return $this->middlename;}
	public function getFirstname(){return $this->firstname;}
	public function getBirthdate(){return $this->birthdate;}
	public function getSex(){return $this->sex;}
	public function getMaritalstatus(){return $this->maritalstatus;}
	public function getHouse_aptno(){return $this->house_aptno;}
	public function getStreetname(){return $this->streetname;}
	public function getCity(){return $this->city;}
	public function getState(){return $this->state;}
	public function getZip(){return $this->zip;}
	public function getEmail(){return $this->email;}
	public function getCellphone(){return $this->cellphone;}
	public function getHomephone(){return $this->homephone;}
	public function getWorkphone(){return $this->workphone;}
	public function getOccupation(){return $this->occupation;}
	public function getMedicinsur_planname(){return $this->medicinsur_planname;}
	public function getEmployer(){return $this->employerid;}
	
	public function setFieldData($param, $value) {
		$this->$param = $value;
		return $this;
	}
	
    public function loadIpp($ippid, $asarray = false)
    {
		if ($asarray) 
		{
			// preparing and executing the research
			$resultSet = $this->fetchAll($this->select()
										->from(array('i' => 'ipps'),
                    						array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
											
										->join(array('c' => 'countries'), 'c.id = i.country', array('Country' => 'name'))
										->where('ippid = ?', $ippid)
										->setIntegrityCheck(false));
			if (!$resultSet or 0 == count($resultSet)) return false;
			$row = $resultSet->current(); 
			$results = array();
			foreach ($row as $obj => $objval) $results[$obj] = $objval;
			return $results;
		}
		else {
			// preparing and executing the research
			$resultSet = $this->fetchAll($this->select()->where('ippid = ?', $ippid));
			if (!$resultSet or 0 == count($resultSet)) return false;
			
			$row = $resultSet->current(); 
			
			foreach ($row as $obj => $objval) $this->setFieldData($obj, $objval);
			return true;
		}
	}

    public function loadIpp_combined($ckey)
    {
		$resultSet = $this->fetchAll($this->select()
		
		
									->from(array('c' => 'customers'))
									->join(array('i' => 'ipps'),'c.ippid = i.ippid',
										array('Last name' => 'lastname','Ippp Id'  => 'ippid', 'Middle name'  => 'middlename', 'First name'  => 'firstname', 'Birth date'  => 'birthdate', 'Sex'  => 'sex', 'Marital status'  => 'maritalstatus', 'House or Apt no'  => 'house_aptno', 'Street name'  => 'streetname', 'City'  => 'city', 'State'  => 'state', 'Zip'  => 'zip', 'Email'  => 'email', 'Address'  => 'address', 'Country Code'  => 'country', 'Cellphone'  => 'cellphone', 'Homephone'  => 'homephone', 'Workphone'  => 'workphone', 'Occupation' => 'occupation', 'Medicinsur_planname' => 'medicinsur_planname', 'employerid' => 'Employerid', 'Address' => 'address', 'Picture' => 'picture'))
										
									->join(array('co' => 'countries'), 'co.id = i.country', array('Country' => 'name'))
									->where('c.ckeystomer = ?', $ckey)
									->setIntegrityCheck(false));
		if (!$resultSet or 0 == count($resultSet)) return false;
		$row = $resultSet->current(); 
		$results = array();
		foreach ($row as $obj => $objval) $results[$obj] = $objval;
		return $results;
		

	}


	public function createIppforMember($firstname,$lastname,$address,$city,$zip,$country,$email,$cellphone,$dob)
	{
		$data = array(
			'lastname' => $firstname,
			'firstname'      => $lastname,
			'address'      => $address,
			'city'      => $city,
			'zip'      => $zip,
			'country'      => $country,
			'email'      => $email,
			'cellphone'      => $cellphone,
			'birthdate'      => $dob
		);
		$this->insert($data);
		return $this->_db->lastInsertId();
	}	
	
	public function updateIppByCat_occupation($id, $occupation)
	{
		$data = array('occupation' => $occupation);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}
	
	public function updateIppByCat_medical($id, $medinsur)
	{
		$data = array('medicinsur_planname' => $medinsur);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}

	public function updateIppByCat_basic($id, $firstname, $middlename, $lastname, $gender, $marital, $birthdate)
	{
		$data = array('firstname' => $firstname,'middlename' => $middlename,'lastname' => $lastname,'sex' => $gender,'maritalstatus' => $marital,'birthdate' => $birthdate);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}

	public function updateIppByCat_contact($id, $email, $address, $apartnum, $streetnum, $zip, $country, $city, $state, $cell, $home, $work)
	{
		$data = array('address' => $address,'house_aptno' => $apartnum,'streetname' => $streetnum,'city' => $city,'state' => $state,'zip' => $zip,'country' => $country,'email' => $email,'cellphone' => $cell,'homephone' => $home,'workphone' => $work);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}	
	
	public function updateIppByCat_picture($id, $picture)
	{
		$data = array('picture' => $picture);
		return $this->_db->update('ipps', $data, array('ippid = '.$id));	
	}		
	
	
	
	
	
	
	
	
	
	
	public function loadModules()
	{
		
		
	}
	public function getRequiredUserDetail($userId)
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('email1', 'firstName','departmentId'))
			->where('id = ?', $userId));
		if (0 == count($resultSet)) return false;
		foreach ($resultSet as $k => $v)
		{
			$rs[] = array(	'email' => $v['email1'], 
							'name' => $v['firstName'],
							'departmentId' => $v['departmentId']);
		}	
		return $rs; 
	}

	public function getDeptId()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$resultSet = $this->fetchRow($this->select()->from($this, array('departmentId'))->where('username = ?', $username));
		
		if (0 == count($resultSet)) return false;
		
		$dept = $resultSet['departmentId'];
		return $dept; 
	}

	public function getUseridByUsername()
	{
		$username = $_SESSION['signingin']['svd_username'];
		$password = $_SESSION['signingin']['svd_password'];
		$resultSet = $this->fetchRow($this->select()
							->from($this, array('id'))
							->where('username = ?', $username)
							->where('password = ?', sha1($password)));
		if (0 == count($resultSet)) return false;
		
		$id = $resultSet['id'];
		return $id;
	}
}
