<?php

class Customers_AppointmentsController extends Zend_Controller_Action
{

    public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		$loadSession = new Auth_Model_Session();	
		$this->view->userislogged = $loadSession->_loadDefaultSession();	
		
		//check if useris required to provide payment information before using the system.
		$payObj = new Common_Model_Payments();	
		if ($payObj->hasCustomerFilledPayAgreement($this->view->userislogged[0][0]) == false)
		{
			$this->view->message = 'Please kindly read and agree to the payment conditions before proceeding. You can click <a href="/patients/payments/plan/selection/options">here</a> to process.';
			$this->_forward('notallowed');
		}
    }

    public function indexAction()
    {
		
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('apm_home_view.php');	
    }
	
    
	public function notallowedAction()
	{
		Zend_Session::namespaceUnset('new_aptm_booking');
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('apm_notallowed_view.php');	
	}
	
    public function settingsAction()
    {
		$request = $this->getRequest();
		$prof_sesion = new Zend_Session_Namespace('appointment_editing_session');
		if ((null ==  $request->getParam('done')) and isset($prof_sesion->update_completed))
		{
			$done = $request->getParam('done');
			$this->view->orign = $prof_sesion->origin; 
			//should be one time operation. So we delete the session space to avoid confusion
			Zend_Session::namespaceUnset('appointment_editing_session');
		}
		
		$settings_obj = new Common_Model_Settings();	
		$settinglist = $settings_obj->getAppointmentsSettingsByCustomer($this->view->userislogged[0][0]);
		
		$this->view->settings = $settinglist;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('apm_settings_view.php');	
    }
	
	public function esettingsAction()
	{
		$this->request = $this->getRequest();
		if (($this->request->getPost('IMT_action_cancelset') !== null) and ($this->request->getPost('IMT_action_cancelset') == 'Cancel'))
		{
			return $this->_redirect('customers/appointments/settings');
		}
		
		$edprofil_objform = new Customers_Form_Appointments();
		$settings_obj = new Common_Model_Settings();	
		$settinglist = $settings_obj->getAppointmentsSettingsByCustomer($this->view->userislogged[0][0]);
		$edprofil_objform->settings($settinglist);
		
		if ($this->request->isPost()) 
		{
			if ($edprofil_objform->isValid($this->request->getPost())) 
			{
				foreach ($settinglist as $k=>$v)
				{
					$namefield = 'IMT_settings'.$v['id'];
					$settings_obj->updateGeneralSettingsForUser($this->view->userislogged[0][0],$v['id'], $this->request->getPost($namefield));
				}
				$user_m_sesion = new Zend_Session_Namespace('appointment_editing_session');
				$user_m_sesion->update_completed = true;
				$user_m_sesion->origin = "settings";
				return $this->_redirect('customers/appointments/settings/done');
			}
			else
			{
				$this->view->notification = "Sorry, we cannot save the changes due to the error highligthed in Red below.";	
			}
		}
		
		$this->view->edit_profile_form = $edprofil_objform;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');
		echo $this->view->render('apm_esettings_view.php');
	}
	
	
	public function newAction()
    {	
		//** Init of the variables default **//
		$aptm_sesion = new Zend_Session_Namespace('new_aptm_booking');
		$form_startapm = new Customers_Form_Appointments();
		$form_startapm_2 = new Customers_Form_Appointments();
		$request = $this->getRequest();
		$step = $request->getParam('s');
		
		//** If cancel option is received, abort all the operations and exit **//
		if (($request->getPost('IMT_action_cancel') !== null) and ($request->getPost('IMT_action_cancel') == 'Cancel'))
		{
			Zend_Session::namespaceUnset('new_aptm_booking');
			return $this->_redirect('customers/portal');
		}
		
		//** Screen the step  **//
		if ($step == "" or $step == "preface")
		{
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'preface')
			{
				return $this->_redirect('customers/appointments/new/s/'.$aptm_sesion->session_started);
			}
			
			//session to be init to preface to get started the process.
			$aptm_sesion->session_started = 'preface'; 
			$form_startapm->preface();
			if ($request->isPost()) 
			{
				if ($form_startapm->isValid($request->getPost())) 
				{
					$aptm_sesion->session_started = 'requests';
					return $this->_redirect('customers/appointments/new/s/requests');
				}
			}
			$this->view->form_startapm = $form_startapm;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_preface_view.php');	
		}
		elseif ($step == "requests") {
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'requests')
			{
				return $this->_redirect('customers/appointments/new/s/'.$aptm_sesion->session_started);
			}
			
			// get all specialistations
			$fields_expters_obj = new Common_Model_Specialisations();
			$all_experts = $fields_expters_obj->getAllSpecialisations(true);
			
			// get all cmmunications method
			$fields_comms_obj = new Common_Model_Communications();
			$all_communications = $fields_comms_obj->getAllCommunications(true);
			
			// Request the form object for validation
			$form_startapm->requests($all_experts['keys'], $all_communications['keys']);
			if ($request->isPost()) 
			{
				if ($form_startapm->isValid($request->getPost())) 
				{
					$aptm_sesion->aptm_details = array(
						'IMT_apm_fieldconsult'=>$request->getPost('IMT_apm_fieldconsult'),
						'IMT_apm_commethod'=>$request->getPost('IMT_apm_commethod'),
						'IMT_apm_dateapm'=>$request->getPost('IMT_apm_dateapm'),
						'IMT_apm_description'=>$request->getPost('IMT_apm_description'),
						'IMT_apm_duration'=>$request->getPost('IMT_apm_duration')
					);
					$aptm_sesion->session_started = 'providers';
					return $this->_redirect('customers/appointments/new/s/providers');	
				}
				else {
					echo '<pre>';print_r($form_startapm->getMessages());
				}
			}
			$this->view->all_experts = $all_experts['full'];
			$this->view->all_communications = $all_communications['full'];
			
			$this->view->form_startapm = $form_startapm;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_requests_view.php');
		}
		elseif ($step == "providers") {
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'providers')
			{
				return $this->_redirect('customers/appointments/new/s/'.$aptm_sesion->session_started);
			}
			
			
			
			
			// Generate the list of available providers
			$fields_provdr_obj = new Common_Model_Provdroptions();
			$all_providers = $fields_provdr_obj->getProvidersByCriteria($aptm_sesion->aptm_details['IMT_apm_fieldconsult'], $aptm_sesion->aptm_details['IMT_apm_dateapm'], intval($aptm_sesion->aptm_details['IMT_apm_duration']), $this->view->userislogged[1]['State']);
			
			// Request the form object for validation
			$form_startapm->providers_select();
			$form_startapm_2->providers_change();
			
			// Proceed to posted data
			if ($request->isPost()) 
			{
				if (($request->getPost('Change') !== null) and ($request->getPost('Change') == 'Change')) 
				{
					if ($form_startapm_2->isValid($request->getPost()))
					{
						$aptm_sesion->session_started = 'requests';
						return $this->_redirect('customers/appointments/new/s/requests');
					}
					else {
						echo '<pre>';print_r($form_startapm_2->getMessages());
						die('should not happen');	
					}
				}
				elseif (($request->getPost('Submit') !== null) and ($request->getPost('Submit') == 'Submit')) 
				{
					if ($form_startapm->isValid($request->getPost()))
					{
						$aptm_sesion->aptm_details['IMT_apm_provider'] = $request->getPost('IMT_apm_provider');
						$aptm_sesion->session_started = 'confirm';
						return $this->_redirect('customers/appointments/new/s/confirm');
					}
					else {
						echo '<pre>';print_r($form_startapm->getMessages());
						die('should not happen');	
					}
				}
			}
			
			$details_aptm = $aptm_sesion->aptm_details;
			// get all specialistations
			$fields_expters_obj = new Common_Model_Specialisations();
			$all_experts = $fields_expters_obj->getAllSpecialisations(true);
			
			// get all cmmunications method
			$fields_comms_obj = new Common_Model_Communications();
			$all_communications = $fields_comms_obj->getAllCommunications(true);
			
			$details_aptm['IMT_apm_fieldconsult'] = $all_experts['keys'][$details_aptm['IMT_apm_fieldconsult']];
			$details_aptm['IMT_apm_commethod'] = $all_communications['keys'][$details_aptm['IMT_apm_commethod']];
			
			$this->view->list_providers = $all_providers;
			$this->view->form_apmdetails = $details_aptm;
			$this->view->form_changepro = $form_startapm_2;
			$this->view->form_selectpro = $form_startapm;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_providers_view.php');
		}
		elseif ($step == "confirm") {
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'confirm')
			{
				return $this->_redirect('customers/appointments/new/s/'.$aptm_sesion->session_started);
			}
			
			$form_startapm->confirm();
			$form_startapm_2->providers_change();
			
			if ($request->isPost()) 
			{
				if (($request->getPost('Change') !== null) and ($request->getPost('Change') == 'Change')) 
				{
					if ($form_startapm_2->isValid($request->getPost()))
					{
						$aptm_sesion->session_started = 'requests';
						return $this->_redirect('customers/appointments/new/s/requests');
					}
					else {
						echo '<pre>';print_r($form_startapm_2->getMessages());
						die('should not happen');	
					}
				}
				elseif (($request->getPost('Submit') !== null) and ($request->getPost('Submit') == 'Submit')) 
				{
					if ($form_startapm->isValid($request->getPost()))
					{
						$fields_provdr_obj = new Common_Model_Appointments();
						$fields_provdr_obj->addAnAppointment($aptm_sesion->aptm_details['IMT_apm_dateapm'], intval($aptm_sesion->aptm_details['IMT_apm_duration']), $this->view->userislogged[0][0],$aptm_sesion->aptm_details['IMT_apm_provider']);
						//die('ss');
						$aptm_sesion->session_started = 'postface';
						return $this->_redirect('customers/appointments/new/s/postface');
					}
					else {
						echo '<pre>';print_r($form_startapm->getMessages());
						die('should not happen');	
					}
				}
			}
			
			$details_aptm = $aptm_sesion->aptm_details;
			// get all specialistations
			$fields_expters_obj = new Common_Model_Specialisations();
			$all_experts = $fields_expters_obj->getAllSpecialisations(true);
			
			// get all cmmunications method
			$fields_comms_obj = new Common_Model_Communications();
			$all_communications = $fields_comms_obj->getAllCommunications(true);
			
			$details_aptm['IMT_apm_fieldconsult'] = $all_experts['keys'][$details_aptm['IMT_apm_fieldconsult']];
			$details_aptm['IMT_apm_commethod'] = $all_communications['keys'][$details_aptm['IMT_apm_commethod']];
			
			//$this->view->list_providers = $all_providers;
			$this->view->form_apmdetails = $details_aptm;
			$this->view->form_confirm = $form_startapm;
			$this->view->form_changepro = $form_startapm_2;
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_confirm_view.php');
		}
		elseif ($step == "postface") {
			if (isset($aptm_sesion->session_started) and $aptm_sesion->session_started != 'postface')
			{
				return $this->_redirect('customers/appointments/new/s/'.$aptm_sesion->session_started);
			}
			Zend_Session::namespaceUnset('new_aptm_booking');
			
			$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
			echo $this->view->render('apm_postface_view.php');
		}
		else {
			// default action
			die("no step provided !!?");
		}
		//die($step);
		
		//$form = new Customers_Form_Appointments();
		/*if ($step == 1) $form->step1();
		elseif ($step == 2) $form->step2();
		elseif ($step == 3) $form->step3();
		elseif ($step == 4) $form->step4();*/
		
		//$this->view->loginForm = $form;
		//$this->view->stepForm = $step;
	
		//$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		//echo $this->view->render('apm_new_view.php');	
	}
}