<?php

class Patients_Form_Appointments extends Zend_Form
{
	public $subContent = "";
    public function init()
    {
	
	}
	
	public function preface()
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		
		$emergcy = new Zend_Form_Element_Button('Yes');
		$emergcy->setLabel('Yes, it is.');	
        $emergcy->setAttrib('id', 'btnEmergency');	
		$emergcy->setAttrib('type', 'button');		
        $emergcy->setAttrib('class', 'btn btn-md btn-danger');		
		$this->addElement($emergcy);
		
		$submit = new Zend_Form_Element_Button('No');
		$submit->setLabel('No, it\'s not');	
        $submit->setAttrib('id', 'btnNotEmergency');	
		$submit->setAttrib('type', 'submit');		
        $submit->setAttrib('class', 'btn btn-success');		
		$this->addElement($submit);
		
        $this->addElement('hash', 'csrf', array('ignore' => true,));	
		
		$this->setElementDecorators(
			array('ViewHelper',
				array('Errors')
			)
		);
		
        $this->setDecorators(array(
            'FormElements',
            array('Form')
			)
		);   
	}
	
	
	

	public function requests()
	{
        $this->setMethod('post'); 
		$this->setAttrib('enctype', 'multipart/form-data'); 

		$this->addElement('text', 'IMT_apm_dateapm', array('required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty')));
		$this->setDefault('IMT_apm_dateapm',date("m/d/Y"));
		$this->addElement('text', 'IMT_apm_timeapm', array('required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty')));
		$this->addElement('text', 'IMT_apm_duration', array('required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty')));
		$this->setDefault('IMT_apm_duration',15);
		
	  
		$this->addElement('submit', 'submit', array('ignore' => true, 'label' => 'APPLY'));
        $this->addElement('hash', 'csrf', array('ignore' => true));
	}
	
	public function providers_change()
	{
        $this->setMethod('post'); 
		
		$this->addElement('submit', 'submit', array('ignore' => true, 'label' => 'Cancel'));
        $this->addElement('hash', 'csrf', array('ignore' => true));
	}
	
	public function providers_select()
	{
        $this->setMethod('post'); 
		$this->setAttrib('enctype', 'multipart/form-data'); 
		
		$this->addElement('submit', 'submit', array('ignore' => true, 'label' => 'APPLY'));
        $this->addElement('hash', 'csrf', array('ignore' => true));
	}
	
	public function confirm()
	{
        $this->setMethod('post'); 
		$this->setAttrib('enctype', 'multipart/form-data'); 
		
		$this->addElement('submit', 'submit', array('ignore' => true, 'label' => 'APPLY'));
        $this->addElement('hash', 'csrf', array('ignore' => true));
	}
	
	
	public function settings($settings)
	{
		$this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->setAttrib('id', 'form_edit_prof');
		$fields = array();
		foreach ($settings as $k=>$v)
		{
			$namefield = 'IMT_settings'.$v['id'];
			if ($v['type'] == 'set')
			{
				$keys_fields = explode(',',$v['options']);
				$values_fields = explode(',',$v['displayoptions']);
				$this->addElement('select', $namefield, array('label'=> $v['name'].':', 'required' => true, 'filters' => array('StringTrim'), 
					'validators' => array(array('InArray', true, array('haystack' => $keys_fields,'messages' => array(Zend_Validate_InArray::NOT_IN_ARRAY => "Value not found")))), 'attribs'=>array('class' => 'form-control', 'placeholder' => ''),'multiOptions' => array_combine($keys_fields, $values_fields)));
			}
			elseif ($v['type'] == 'int')
			{
				$this->addElement('text', $namefield, array('label'=> $v['name'].':', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
			}
			
			$fields[] = $namefield;
			if (isset($v['value'])) 
			{
				$this->setDefaults(array(
					$namefield => $v['value']
				));
			}
			else {
				$this->setDefaults(array(
					$namefield => $v['default_value']
				));
			}
		}
		
		$this->addDisplayGroup($fields, 'topf');
		$submit = new Zend_Form_Element_Button('Save');
		$submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');
		$cancel = new Zend_Form_Element_Button('Cancel');
		$cancel->setAttrib('id','cancel')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-danger pull-left');		
		$this->addElements(array($cancel, $submit));
        $this->addElement('hash', 'csrf', array('ignore' => false,));	
		$this->addDisplayGroup(array($cancel, $submit, 'csrf'), 'topb');
		
		//Setting decorators//
		foreach ($fields as $field => $datafield)
		{
			$this->setElementDecorators(array(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array('Description'), array('Errors'),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label', array('class'=> 'label')), array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))), array($datafield));
		}
			
		$submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6')))); 
		$cancel->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section', 'class'=> 'col-md-6'))));   
        $this->getDisplayGroup('topf')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')))); 
		$this->getDisplayGroup('topb')->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset'))));  
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input-error-m">')->setElementEnd('</span>');
	}
	
}