<?php

class Ccdsa_Form_Userprofile extends Zend_Form
{
	public $subContent = "";
    public function init()
    {}
	
	public function login()
	{
        $this->setMethod('post'); 
        $this->addElement('text', 'candi_email', array('label'=> 'Email Address:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty','EmailAddress'),'attribs'=>array('class' => 'form-control', 'placeholder' => 'Please enter your email address')));
 
        $this->addElement('password', 'candi_password', array('label'=> 'Password:','required' => true,'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),'attribs'=>array('class' => 'form-control', 'placeholder' => 'Please enter your password')));
		
        $this->addElement('submit', 'submit',array('ignore' => true, 'label' => 'SIGN IN','attribs'=>array('class' => 'btn btn-lg btn-primary btn-block')));
				
        $this->addElement('hash', 'csrf', array('ignore' => true,));	
	}	


	public function basicprofile()
	{
        $this->setMethod('post'); 
        $this->addElement('text', 'candi_fname', array('label'=> 'First Name:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty', array('Regex',false, array('/^[a-z][a-z0-9., \'-]{2,}$/i'))),	'attribs'=>array('class' => 'form-control', 'placeholder' => '') ));
		
        $this->addElement('text', 'candi_lname', array('label'=> 'Last Name:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty', array('Regex',false, array('/^[a-z][a-z0-9., \'-]{2,}$/i'))), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		
        $this->addElement('text', 'candi_email', array('label'=> 'Email Address:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty','EmailAddress'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		
        $this->addElement('password', 'candi_password', array('label'=> 'Password:','required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		
        $this->addElement(
			'password', 'candi_rpassword', 
			array(
				'label'=> 'Repeat the password:', 
				'required' => true, 
				'filters' => array('StringTrim'),
				'validators' => array(
					array(
						'name' => 'StringLength',
						'options' => array(
							'encoding' => 'UTF-8',
							'min' => 3,
							'max' => 32)
						), 
					array('identical', false, array('token' => 'candi_password'))					),
				'attribs'=>array('class' => 'form-control')));		
	
        $this->addElement('submit', 'submit', array('ignore' => true, 'label' => 'JOIN IN', 'attribs'=>array('class' => 'btn btn-lg btn-primary btn-block')));
				
        $this->addElement('hash', 'csrf', array('ignore' => true,));	
	}



	public function persona()
	{
		$this->subContent = new Ccdsa_Model_CountriesMapper();
		$result = $this->subContent->fetchAll();
		foreach ($result as $key=>$data){$list_Countries[$data->getName()] = $data->getName();}
		
        $this->setMethod('post'); 
        $this->addElement(
			'text', 'candi_fname', array('label'=> 'First Name:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),	'attribs'=>array('class' => 'form-control', 'placeholder' => '') ));
        $this->addElement(
			'text', 'candi_lname', array('label'=> 'Last Name:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => '')));
		
		$this->addElement('select', 'candi_gender', array('label'=> 'Gender:', 'required'=> true, 'filters'    => array('StringTrim'), 'validators' => array(), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Please enter your email address'), 'multiOptions' => array('' => 'Click to select', 'Male' => 'Male', 'Female' => 'Female')));
		
		$this->addElement('select', 'candi_nationality', array('label'=> 'Nationality:', 'required'=> true, 'filters'    => array('StringTrim'), 'validators' => array(), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Please enter your email address'), 'multiOptions' => $list_Countries));
		

        $this->addElement('text', 'candi_tel', array('label'=> 'Telephone number:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty'	),'attribs'=>array('class' => 'form-control', 'placeholder' => '')));

		$this->addElement('select', 'candi_residence', array('label'=> 'Residence Location:', 'required'=> true, 'filters'    => array('StringTrim'), 'validators' => array(), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Please enter your email address'), 'multiOptions' => $list_Countries));
		
		
		
        $this->addElement(
			'submit', 'submit', 
			array(
				'ignore' => true, 
				'label' => 'UPDATE YOUR DATA', 
				'attribs'=>array('class' => 'btn btn-lg btn-primary btn-block')
			)
		);
				
        $this->addElement('hash', 'csrf', array('ignore' => true,));	
		
	}

/*

+ Target Industry [3options]
+ Target Job location [3options]
+ Employment status
+ Career Objective [Your Career Objective is a brief statement of what you are looking for]
+ Original CV
+ Salary expectations*/
	
	public function mypro()
	{
		$this->subContent = new Ccdsa_Model_CountriesMapper();
		$result = $this->subContent->fetchAll();
		foreach ($result as $key=>$data){$list_Countries[$data->getName()] = $data->getName();}
		
		$this->subContent = new Ccdsa_Model_JcategoriesMapper();
		$result = $this->subContent->fetchAll();
		foreach ($result as $key=>$data){$list_Categories[$data->getName()] = $data->getName();}

		
        $this->setMethod('post'); 
		$this->setAttrib('enctype', 'multipart/form-data'); 
		
        $this->addElement('multiselect', 'candi_industry', array('label'=> 'Target Industry:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),'attribs'=>array('class' => 'form-control', 'placeholder' => 'Select no more than 3 choices.'), 'multiOptions' => $list_Categories));
		
        $this->addElement('multiselect', 'candi_targjob', array('label'=> 'Target Job Location:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),'attribs'=>array('class' => 'form-control'), 'multiOptions' => $list_Countries));		
		
		
		$this->addElement('select', 'candi_empstate', array('label'=> 'Employment Status:', 'required'=> true, 'filters'    => array('StringTrim'), 'validators' => array(), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Please enter your email address'), 'multiOptions' => array('' => 'Click to select', 'emp' => 'Employed', 'notemp' => 'Unemployed')));
		
		
        $this->addElement('textarea', 'candi_objective', array('label'=> 'Career Objective:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),'attribs'=>array('class' => 'form-control', 'placeholder' => 'Brief statement of what you are looking for.')));

        $this->addElement('file', 'candi_usecv', 
			array(
				'label'=> 'Original CV:', 
				'required' => true,
				'destination'=> '/var/www/html/teamcgconsult/main/data/orgincvs', 	
				'validators' => array(array('Count', false, 1),array('Size', false, 102400),array('Extension', false, 'pdf,doc,docx')),			
				'attribs'=>array() 
			));
		
		
        $this->addElement('text', 'candi_salary', array('label'=> 'Monthly Salary Expectations (In US Dollars):', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty','Int'),'attribs'=>array('class' => 'form-control', 'placeholder' => 'Ex: 3000')));
		
        $this->addElement(
			'submit', 'submit', 
			array(
				'ignore' => true, 
				'label' => 'UPDATE YOUR DATA', 
				'attribs'=>array('class' => 'btn btn-lg btn-primary btn-block')
			)
		);
				
        $this->addElement('hash', 'csrf', array('ignore' => true,));	
		
	}
	

	
	public function profilupdate()
	{
        $this->setMethod('post'); 
        $this->addElement('text', 'candi_email', array('label'=> 'Email Address:', 'required' => true, 'filters' => array('StringTrim'), 'validators' => array('NotEmpty','EmailAddress'),'attribs'=>array('class' => 'form-control', 'readonly'=>'readonly')));
 
        $this->addElement('password', 'candi_cpassword', array('label'=> 'Current Password:','required' => true,'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),'attribs'=>array('class' => 'form-control')));
 
        $this->addElement('password', 'candi_npassword', array('label'=> 'New Password:','required' => true,'filters' => array('StringTrim'), 'validators' => array('NotEmpty'),'attribs'=>array('class' => 'form-control')));

        $this->addElement(
			'password', 'candi_rpassword', 
			array(
				'label'=> 'Repeat the new password:', 
				'required' => true, 
				'filters' => array('StringTrim'),
				'validators' => array(
					array(
						'name' => 'StringLength',
						'options' => array(
							'encoding' => 'UTF-8',
							'min' => 3,
							'max' => 32)
						), 
					array('identical', false, array('token' => 'candi_npassword'))					),
				'attribs'=>array('class' => 'form-control')));		
		
		
        $this->addElement('submit', 'submit',array('ignore' => true, 'label' => 'UPDATE MY DATA','attribs'=>array('class' => 'btn btn-lg btn-primary btn-block')));
				
        $this->addElement('hash', 'csrf', array('ignore' => true,));	
	}
		
}