<?php

class AccessController extends Zend_Controller_Action
{
	public function init()
    {
		$this->_helper->viewRenderer->setNoRender();
		
		
    }
	
	
	
    public function loginAction()
    {
		$form = new Auth_Form_Access();
		$form->login();
		$request = $this->getRequest();
		if ($request->isPost()) 
		{
			if ($form->isValid($request->getPost())) 
			{
				$this->ulogin = new Auth_Model_Authmembers();
				$loadMemberCheck = $this->ulogin->findMember($request->getPost('imatmlogin'),$request->getPost('imatmpassword'));
				if ($loadMemberCheck == false)
				{
					$this->view->notification = 'The username or password you have entered does not exist.';
					$form->populate($request->getPost());
				}
				elseif ($loadMemberCheck[3] == 0)
				{
					$this->view->notification = 'Your account is not yet activated. Please activate the account using the link provided in the email.';
					$form->populate($request->getPost());
				}
				else
				{
					$cs_session_global = new Zend_Session_Namespace('member_is_logged_in');
					$cs_session_global->svd_username = $request->getPost('imatmlogin');
					$cs_session_global->svd_password = $request->getPost('imatmpassword');
					return $this->_redirect('patients/portal');	
				}
			}
			else {
				$this->view->notification = 'The username or password is missing or incorrect.';
				$form->populate($request->getPost());	
			}
		}
		$this->view->loginForm = $form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('login_view.php');	
	}
	
    public function registerAction()
    {
		$form = new Auth_Form_Access();
		$countryObj = new Common_Model_Countries();	
		$countries = $countryObj->getAllCountries(true);
		$this->view->errors_form = false;
		$form->signup($countries['keys']);
		$this->request = $this->getRequest();
		
		if ($this->request->isPost()) 
		{
			if ($form->isValid($this->request->getPost())) 
			{
				if (null == $this->_getParam('IMAT_mbr_conditions', null))
				{
					$this->view->errors_form = true;
					$this->view->notification = 'Please accept the terms and conditions before you can complete the registration.';
				}
				else {
					$ulogin = new Auth_Model_Authmembers();
					if ($ulogin->findMember($this->request->getPost('IMAT_mbr_username')) != false)
					{
						$this->view->errors_form = true;
						$this->view->notification = 'Sorry, the username is already in use.';
					}
					else {
						$session_key = sha1($this->request->getPost('IMAT_mbr_firstname')).sha1($this->request->getPost('IMAT_mbr_lastname')).sha1(time());
						
						$mbr_obj = new Common_Model_Ippps();
						$idr = $mbr_obj->createIppforMember($this->request->getPost('IMAT_mbr_firstname'),$this->request->getPost('IMAT_mbr_lastname'),$this->request->getPost('IMAT_mbr_address'),$this->request->getPost('IMAT_mbr_city'),$this->request->getPost('IMAT_mbr_zipcode'),$this->request->getPost('IMAT_mbr_country'),$this->request->getPost('IMAT_mbr_email'),$this->request->getPost('IMAT_mbr_telephone'),$this->request->getPost('IMAT_mbr_dob'));
						$mbr_obj = new Common_Model_Members();
						$mbr_obj->createMember($idr, $this->request->getPost('IMAT_mbr_username'), $this->request->getPost('IMAT_mbr_password'),$session_key);
						
						
						
						$linkofactivation = 'http://demo2.citeso.com/members/activate/key/'.$session_key;	
						$message_to_opener ='<span style="font-family:\'Segoe UI\'"><p>Dear '.$this->request->getPost('IMAT_mbr_firstname').', <br /><br />
Thank you for registering. In order to activate your  account, please click on the following link <br />
<a href="'.$linkofactivation.'">Activate  my account</a> <br /><br />
Or copy and paste this link<br />
 '.$linkofactivation.' in your web browser. </p>
    <p>Sincerely yours.<br />
      iMatter Automated Registration System</p></span>';
	  
						$subject_to_opener =  "iMatter registration of account";
						$to_to_opener      = $this->request->getPost('IMAT_mbr_email'); 
						$headers = "From:iMatter Registration Deptm. <registration@imatter.co>";
						$headers  .= 'MIME-Version: 1.0' . "\r\n";
						$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";								
						
						@mail($to_to_opener, $subject_to_opener, $message_to_opener, $headers);
						$this->view->completed = true;
						
					}
				}
			}
			else {
				$this->view->errors_form = true;
				$this->view->error_message = $form->getMessages();
				$this->view->notification = 'Errors in the form. Please fill or correct the fields highlithed in red.';
			}
		}
		
		$this->view->countries = $countries['full'];
		$this->view->signupform = $form;
		$this->view->setScriptPath(CURRENT_MODULE_FOLDER.'/views/');		
		echo $this->view->render('signup_view.php');	
	}	
	
	public function logoutAction()
    {		
	
		$cs_session_global = new Zend_Session_Namespace('member_is_logged_in');	
		unset($cs_session_global->svd_username);
		unset($cs_session_global->svd_password);		
		
		return $this->_redirect('/patients');
	}	
	
}
