<?php

class Common_Model_Billing extends Zend_Db_Table_Abstract
{
    protected $_name = 'billing';
	protected $_primary = 'id';
	
	
	public function getBillingInfo($id, $isforview = false)
	{
		if ($isforview == true)
		{
			$resultSet = $this->fetchAll($this->select()
										->from(array('b' => 'billing'),
                    						array('IMT_pay_firstname' => 'firstname','IMT_pay_lastname' => 'lastname','IMT_pay_address' => 'address','IMT_pay_city' => 'city','IMT_pay_country' => 'country','IMT_pay_email' => 'email','IMT_pay_phone' => 'cellphone','IMT_pay_zipcode' => 'zip'))
										->where('id = ?', $id));
			
			if (!$resultSet or 0 == count($resultSet)) return false;
			$row = $resultSet->current(); 
			$results = array();
			foreach ($row as $obj => $objval) $results[$obj] = $objval;
			return $results;
		}
		else
		{
			$resultSet = $this->fetchAll($this->select()
										->from(array('b' => 'billing'),
                    						array('firstname' => 'firstname','lastname' => 'lastname','address' => 'address','city' => 'city','country' => 'country','email' => 'email','phone' => 'cellphone','zipcode' => 'zip'))
										->join(array('ct' => 'countries'), 'ct.id = b.country', array('countryname' => 'name'))
										->where('b.id = ?', $id)
										->setIntegrityCheck(false));
			
			if (!$resultSet or 0 == count($resultSet)) return false;
			$row = $resultSet->current(); 
			$results = array();
			foreach ($row as $obj => $objval) $results[$obj] = $objval;
			return $results;
		}
	}
	
	public function createBillingInfo($cid,$firstname,$lastname,$address,$city,$zip,$country,$email,$cellphone,$sameasprofile)
	{
		$data = array(
			'lastname' => $firstname,
			'firstname'      => $lastname,
			'address'      => $address,
			'city'      => $city,
			'zip'      => $zip,
			'country'      => $country,
			'email'      => $email,
			'cellphone'      => $cellphone,
			'sameasprofile'      => $sameasprofile
		);
		$this->insert($data);
		//insert in table customers
		$id = $this->_db->lastInsertId();
		$data = array('billingid' => $id);
		return $this->_db->update('customers', $data, array('id = '.$cid));
	}
	
	public function updateBillingInfo($bid,$firstname,$lastname,$address,$city,$zip,$country,$email,$cellphone,$sameasprofile)
	{
		$data = array('lastname' => $firstname,
			'firstname'      => $lastname,
			'address'      => $address,
			'city'      => $city,
			'zip'      => $zip,
			'country'      => $country,
			'email'      => $email,
			'cellphone'      => $cellphone,
			'sameasprofile'      => $sameasprofile);
		
		return $this->_db->update('billing', $data, array('id = '.$bid));
	}
	
	public function getBillingRecords($cid)
	{
		//$resultSet = $this->fetchAll($this->select()->from(array('br' => 'billing_records'),array('id' => 'id', 'billnumber' => 'billnumber', 'date' => 'date', 'total' => 'total', 'status' => 'status'))->where('br.cid = ?',$cid)->setIntegrityCheck(false));
		//if (!$resultSet or 0 == count($resultSet)) return false;
		//return $resultSet;
		return false;
	}
	
	
	
}
