<?php

class Common_Model_Accounts extends Zend_Db_Table_Abstract
{
    protected $_name = 'accounts';
	protected $_primary = 'id';
	 
	public function find_key($activationkey)
	{
		$result = $this->fetchRow($this->select()->from(array('a' => 'accounts'),array('id' => 'id','activationkey' => 'activationkey','accountactivated' => 'accountactivated', 'activationdate' => 'activationdate', 'object' => 'object'))->where('activationkey = ?', $activationkey));
		
		if (0 == count($result) or $result['accountactivated'] == 1) return false;
		return $result;
	}
	
	public function activate_account($id)
	{
		$data = array('accountactivated' => 1,
              'activationdate' => new Zend_Db_Expr('NOW()'));
		return $this->_db->update('accounts', $data, array('id = '.$id));
	}
	

    public function find_account($username, $password = NULL, $strict = false)
    {
		$result = $this->fetchRow($this->select()->from(array('a' => 'accounts'), array('password','accountactivated','activationkey','object'))->where('username = ?', $username));
		if (0 == count($result)) return false;
		if (is_null($password))
		{
			if ($result['object'] == 'c') $valObject = 'patients';
			elseif ($result['object'] == 'p') $valObject = 'providers';
			return array($result['accountactivated'],$result['activationkey'],$result['object'], $valObject);
		}
		else
		{
			if (sha1($password) != $result['password']) return false;
			else {
				if ($result['object'] == 'c') $valObject = 'patients';
				elseif ($result['object'] == 'p') $valObject = 'providers';
				return array($result['accountactivated'],$result['activationkey'],$result['object'], $valObject);
			}
		}
	}
	
	public function check_password($id, $password)
	{
		$resultSet = $this->fetchAll($this->select()->where('id = ?', $id));
		if (0 == count($resultSet)) return false;
		$row = $resultSet->current(); 
		if ($this->crypPassword($password) != $row['password']) return false;
		return $row['password'];
	}
	
	public function crypPassword($password)
	{
		return sha1($password);	
	}
	
	public function updatePassword($id, $password)
	{
		$data = array('password' => $this->crypPassword($password));
		return $this->_db->update('customers', $data, array('id = '.$id));
	}
	
	
}
