<?php

class Auth_Form_Access extends Zend_Form
{
	public $subContent = "";
    public function init()
    {
	
	}
	

	public function signup($list_countries)
	{
        $this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		$this->addElement('text', 'IMAT_mbr_username', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty','Alnum')));
		$this->addElement('password', 'IMAT_mbr_password', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty')));
		$this->addElement('password', 'IMAT_mbr_cpassword', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array(array('identical', false, array('token' => 'IMAT_mbr_password')))));
		$this->addElement('password', 'IMAT_mbr_email', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty', 'EmailAddress')));
		$this->addElement('password', 'IMAT_mbr_cemail', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array(array('identical', false, array('token' => 'IMAT_mbr_email')))));
		
		$this->addElement('text', 'IMAT_mbr_firstname', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty')));
		$this->addElement('text', 'IMAT_mbr_lastname', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty')));
		$this->addElement('text', 'IMAT_mbr_telephone', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty')));
		$this->addElement('text', 'IMAT_mbr_ctelephone', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array(array('identical', false, array('token' => 'IMAT_mbr_telephone')))));
		$this->addElement('text', 'IMAT_mbr_dob', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array(array('NotEmpty','Date',array('format'=>'dd/MM/yyyy')))));
		

		$this->addElement('select', 'IMAT_mbr_country', array('required'=> true, 'filters' => array('StringTrim'), 'validators' => array(), 'multiOptions' => $list_countries));		
		$this->addElement('text', 'IMAT_mbr_city', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty')));
		$this->addElement('text', 'IMAT_mbr_zipcode', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty')));
		$this->addElement('text', 'IMAT_mbr_address', array('required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty')));
		
		$this->addElement('text', 'IMAT_mbr_veterannum', array('required' => false, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('')));
		
		
		
        

		$submit = new Zend_Form_Element_Button('Login');
        $submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');		
		$this->addElement($submit);
				
        $this->addElement('hash', 'csrf', array('ignore' => true, 'timeout' => 60000));	 				
		
	}
	
	public function login()
	{
        $this->setMethod('post'); 
		$this->setAttrib('class', 'sky-form');
		
        $this->addElement('text', 'imatmlogin', array('label'=> 'Username', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Username'), 'decorators'    => array(array('divWrapper' => 'HtmlTag'), array())));
						
		$this->addElement('password', 'imatmpassword', array('label'=> 'Password:', 'required' => true, 'filters' => array('StringTrim', 'StringToLower'), 'validators' => array('NotEmpty'), 'attribs'=>array('class' => 'form-control', 'placeholder' => 'Password')));

		$submit = new Zend_Form_Element_Button('Login');
        $submit->setAttrib('id', 'submit')->setAttrib('type', 'submit')->setAttrib('class', 'btn btn-base btn-icon btn-icon-right pull-right');		
		$this->addElement($submit);
				
        $this->addElement('hash', 'csrf', array('ignore' => true,));	
		$this->setElementDecorators(array('ViewHelper',array('Description'),array('Errors'),array(array('divWrapper' => 'HtmlTag'), array('tag' => 'divs', 'placement' => 'prepend')),array(array('data' => 'HtmlTag'), array('tag' => 'label', 'class' => 'input')), array('Label'),array(array('label' => 'HtmlTag'), array('tag' => 'div', 'class'=> 'form-group')), array(array('row' => 'HtmlTag'), array('tag' => 'section'))));
		
        $submit->setDecorators(array('ViewHelper', array(array('row' => 'HtmlTag'), array('tag' => 'section'))));      
        $this->setDecorators(array('FormElements', array('HtmlTag', array('tag' => 'fieldset')), array('Form')));
		                     
        $view = $this->getView();
        $formErrors = $view->getHelper('formErrors');
        $formErrors->setElementStart('<span class="input_error">')->setElementSeparator('')    ->setElementEnd('</span>');  				
		
	}
}